/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.infinispan.embedded;

import io.reactivex.rxjava3.schedulers.Schedulers;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.LifecycleException;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.jboss.logging.Logger;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.jmx.JmxConfigurator;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.cache.infinispan.marshalling.MediaTypes;
import org.wildfly.clustering.cache.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.affinity.UnaryGroupMemberAffinity;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.LocalEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.JChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.affinity.UnarySessionAffinity;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKey;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionProvider;
import org.wildfly.clustering.tomcat.catalina.AbstractManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionContext;
import org.wildfly.clustering.tomcat.infinispan.embedded.DefaultBlockingThreadFactory;
import org.wildfly.clustering.tomcat.infinispan.embedded.DefaultNonBlockingThreadFactory;
import org.wildfly.clustering.tomcat.infinispan.embedded.ForkChannelConfigurator;
import org.wildfly.clustering.tomcat.infinispan.embedded.JChannelConfigurator;

public class InfinispanManager
extends AbstractManager {
    static final Logger LOGGER = Logger.getLogger(InfinispanManager.class);
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private volatile String resourceName = "infinispan.xml";
    private volatile String cacheName = null;

    public void setResource(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setTemplate(String cacheName) {
        this.cacheName = cacheName;
    }

    protected Map.Entry<SessionManagerFactory<ServletContext, CatalinaSessionContext>, UnaryOperator<String>> createSessionManagerFactory(SessionManagerFactoryConfiguration<CatalinaSessionContext> config, String localRoute, Consumer<Runnable> stopTasks) throws LifecycleException {
        COUNTER.incrementAndGet();
        stopTasks.accept(() -> {
            if (COUNTER.decrementAndGet() == 0) {
                Schedulers.shutdown();
            }
        });
        ClassLoader loader = this.getContext().getLoader().getClassLoader();
        try {
            Configuration template;
            JChannelCommandDispatcherFactory channelCommandDispatcherFactory;
            JChannel channel;
            URL url = loader.getResource(this.resourceName);
            if (url == null) {
                File file = new File(this.resourceName);
                if (file.exists()) {
                    url = file.toURI().toURL();
                } else {
                    throw new IllegalArgumentException(this.resourceName);
                }
            }
            LOGGER.debugf("Configuring Infinispan from %s", (Object)url);
            ConfigurationBuilderHolder holder = new ParserRegistry(loader, false, System.getProperties()).parse(url);
            GlobalConfigurationBuilder global = holder.getGlobalConfigurationBuilder();
            String containerName = global.cacheContainer().name();
            TransportConfiguration transport = global.transport().nodeName(localRoute).create();
            JChannelConfigurator configurator = transport.transport() != null ? new JChannelConfigurator(transport, loader) : null;
            JChannel jChannel = channel = configurator != null ? configurator.createChannel(null) : null;
            if (channel != null) {
                channel.setName(transport.nodeName());
                channel.setDiscardOwnMessages(true);
                LOGGER.debugf("Connecting %s to %s", (Object)transport.nodeName(), (Object)transport.clusterName());
                channel.connect(transport.clusterName());
                LOGGER.debugf("Connected %s to %s with view: %s", (Object)channel.getName(), (Object)channel.getClusterName(), (Object)channel.view().getMembers());
                stopTasks.accept(() -> {
                    LOGGER.debugf("Disconnecting %s from %s with view: %s", (Object)channel.getName(), (Object)channel.getClusterName(), (Object)channel.view().getMembers());
                    try {
                        channel.disconnect();
                        LOGGER.debugf("Disconnected %s from %s", (Object)transport.nodeName(), (Object)transport.clusterName());
                    }
                    finally {
                        channel.close();
                    }
                });
                GlobalJmxConfiguration jmx = global.jmx().create();
                if (jmx.enabled()) {
                    ObjectName prefix = new ObjectName(jmx.domain(), "manager", ObjectName.quote(containerName));
                    JmxConfigurator.registerChannel((JChannel)channel, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ObjectName)prefix, (String)transport.clusterName(), (boolean)true);
                    stopTasks.accept(() -> {
                        try {
                            JmxConfigurator.unregisterChannel((JChannel)channel, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ObjectName)prefix, (String)transport.clusterName());
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    });
                }
                Properties properties = new Properties();
                properties.put("channelConfigurator", new ForkChannelConfigurator(channel, containerName));
                global.transport().withProperties(properties);
            }
            JChannelCommandDispatcherFactory jChannelCommandDispatcherFactory = channelCommandDispatcherFactory = channel != null ? new JChannelCommandDispatcherFactory(new JChannelCommandDispatcherFactoryConfiguration(){
                final /* synthetic */ InfinispanManager this$0;
                {
                    this.this$0 = this$0;
                }

                public JChannel getChannel() {
                    return channel;
                }

                public ByteBufferMarshaller getMarshaller() {
                    return this.getMarshallerFactory().apply(JChannelCommandDispatcherFactory.class.getClassLoader());
                }

                public Function<ClassLoader, ByteBufferMarshaller> getMarshallerFactory() {
                    return loader -> new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader)).build());
                }

                public Predicate<Message> getUnknownForkPredicate() {
                    return Predicate.not(Message::hasPayload);
                }
            }) : null;
            if (channelCommandDispatcherFactory != null) {
                stopTasks.accept(() -> ((ChannelCommandDispatcherFactory)channelCommandDispatcherFactory).close());
            }
            global.classLoader(loader).shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER).blockingThreadPool().threadFactory((ThreadFactory)((Object)new DefaultBlockingThreadFactory(BlockingManager.class))).expirationThreadPool().threadFactory((ThreadFactory)((Object)new DefaultBlockingThreadFactory(ExpirationManager.class))).listenerThreadPool().threadFactory((ThreadFactory)((Object)new DefaultBlockingThreadFactory(ListenerInvocation.class))).nonBlockingThreadPool().threadFactory((ThreadFactory)((Object)new DefaultNonBlockingThreadFactory(NonBlockingManager.class))).serialization().marshaller((Marshaller)new UserMarshaller((Supplier)MediaTypes.WILDFLY_PROTOSTREAM, (ByteBufferMarshaller)new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader)).build()))).addContextInitializer(new SerializationContextInitializer(){

                @Deprecated
                public String getProtoFile() {
                    return null;
                }

                @Deprecated
                public String getProtoFileName() {
                    return null;
                }

                public void registerMarshallers(SerializationContext context) {
                }

                public void registerSchema(SerializationContext context) {
                }
            }).globalState().configurationStorage(ConfigurationStorage.IMMUTABLE).disable();
            DefaultCacheManager container = new DefaultCacheManager(holder, false);
            container.start();
            stopTasks.accept(() -> ((EmbeddedCacheManager)container).stop());
            Configuration configuration = template = this.cacheName != null ? container.getCacheConfiguration(this.cacheName) : container.getDefaultCacheConfiguration();
            if (template == null) {
                throw new IllegalArgumentException(this.cacheName);
            }
            ConfigurationBuilder builder = new ConfigurationBuilder().read(template).template(false);
            builder.encoding().mediaType("application/x-java-object");
            if (template.invocationBatching().enabled()) {
                builder.invocationBatching().disable();
                builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup(EmbeddedTransactionManager::getInstance);
            }
            builder.expiration().lifespan(-1L).maxIdle(-1L).disableReaper().wakeUpInterval(-1L);
            OptionalInt maxActiveSessions = config.getMaxActiveSessions();
            EvictionStrategy eviction = maxActiveSessions.isPresent() ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL;
            builder.memory().storage(StorageType.HEAP).whenFull(eviction).maxCount((long)maxActiveSessions.orElse(-1));
            if (eviction.isEnabled()) {
                ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(SessionMetaDataKey.class::isInstance);
            }
            String cacheName = config.getDeploymentName();
            container.defineConfiguration(cacheName, builder.build());
            stopTasks.accept(() -> InfinispanManager.lambda$createSessionManagerFactory$3((EmbeddedCacheManager)container, cacheName));
            EmbeddedCacheManagerCommandDispatcherFactory commandDispatcherFactory = channelCommandDispatcherFactory != null ? new EmbeddedCacheManagerCommandDispatcherFactory((EmbeddedCacheManagerCommandDispatcherFactoryConfiguration)new ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){
                final /* synthetic */ ChannelCommandDispatcherFactory val$channelCommandDispatcherFactory;
                final /* synthetic */ EmbeddedCacheManager val$container;
                final /* synthetic */ InfinispanManager this$0;
                {
                    this.val$channelCommandDispatcherFactory = channelCommandDispatcherFactory;
                    this.val$container = embeddedCacheManager;
                    this.this$0 = this$0;
                }

                public GroupCommandDispatcherFactory<Address, ChannelGroupMember> getCommandDispatcherFactory() {
                    return this.val$channelCommandDispatcherFactory;
                }

                public EmbeddedCacheManager getCacheContainer() {
                    return this.val$container;
                }
            }) : new EmbeddedCacheManagerCommandDispatcherFactory((EmbeddedCacheManagerCommandDispatcherFactoryConfiguration)new LocalEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){
                final /* synthetic */ EmbeddedCacheManager val$container;
                final /* synthetic */ InfinispanManager this$0;
                {
                    this.val$container = embeddedCacheManager;
                    this.this$0 = this$0;
                }

                public EmbeddedCacheManager getCacheContainer() {
                    return this.val$container;
                }
            });
            final Cache cache = container.getCache(cacheName);
            cache.start();
            stopTasks.accept(() -> ((Cache)cache).stop());
            return Map.entry(new InfinispanSessionManagerFactory(config, (SessionSpecificationProvider)HttpSessionProvider.INSTANCE, (SessionEventListenerSpecificationProvider)HttpSessionActivationListenerProvider.INSTANCE, new InfinispanSessionManagerFactoryConfiguration(){
                final /* synthetic */ CacheContainerCommandDispatcherFactory val$commandDispatcherFactory;
                final /* synthetic */ InfinispanManager this$0;
                {
                    this.val$commandDispatcherFactory = cacheContainerCommandDispatcherFactory;
                    this.this$0 = this$0;
                }

                public <K, V> Cache<K, V> getCache() {
                    return cache;
                }

                public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                    return this.val$commandDispatcherFactory;
                }
            }), new UnarySessionAffinity((Function)new UnaryGroupMemberAffinity(cache, commandDispatcherFactory.getGroup()), GroupMember::getName));
        }
        catch (LifecycleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$createSessionManagerFactory$3(EmbeddedCacheManager container, String cacheName) {
        container.undefineConfiguration(cacheName);
    }
}

