/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.infinispan.remote;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.commons.marshall.Marshaller;
import org.wildfly.clustering.cache.function.IntPredicates;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.Marshallability;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactory;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.session.spec.servlet.HttpSessionProvider;
import org.wildfly.clustering.tomcat.SessionManagerConfiguration;
import org.wildfly.clustering.tomcat.SessionMarshallerFactory;
import org.wildfly.clustering.tomcat.SessionPersistenceGranularity;
import org.wildfly.clustering.tomcat.catalina.CatalinaIdentifierFactory;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionContext;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionExpirationListener;
import org.wildfly.clustering.tomcat.catalina.DistributableManager;

public class HotRodManager
extends ManagerBase {
    static final ToIntFunction<ServletContext> SESSION_TIMEOUT_FUNCTION = ServletContext::getSessionTimeout;
    private final Properties properties = new Properties();
    private final List<Runnable> stopTasks = new LinkedList<Runnable>();
    private volatile CatalinaManager<TransactionBatch> manager;
    private volatile SessionAttributePersistenceStrategy persistenceStrategy = SessionPersistenceGranularity.SESSION.get();
    private volatile SessionMarshallerFactory marshallerFactory = SessionMarshallerFactory.JBOSS;
    private volatile String templateName = DefaultTemplate.DIST_SYNC.getTemplateName();
    private volatile URI uri = null;

    public void setUri(String uri) {
        this.uri = URI.create(uri);
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty("infinispan.client.hotrod." + name, value);
    }

    public void setPersistenceStrategy(SessionAttributePersistenceStrategy strategy) {
        this.persistenceStrategy = strategy;
    }

    public void setGranularity(SessionPersistenceGranularity granularity) {
        this.setPersistenceStrategy(granularity.get());
    }

    public void setGranularity(String granularity) {
        this.setGranularity(SessionPersistenceGranularity.valueOf((String)granularity));
    }

    public void setTemplate(String templateName) {
        this.templateName = templateName;
    }

    public void setMarshallerFactory(SessionMarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
    }

    public void setMarshaller(String marshallerFactory) {
        this.setMarshallerFactory(SessionMarshallerFactory.valueOf((String)marshallerFactory));
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        Context context = this.getContext();
        Host host = (Host)context.getParent();
        final Engine engine = (Engine)host.getParent();
        final ServletContext servletContext = context.getServletContext();
        final String deploymentName = host.getName() + context.getName();
        final OptionalInt maxActiveSessions = IntStream.of(this.getMaxActiveSessions()).filter((IntPredicate)IntPredicates.POSITIVE).findFirst();
        final SessionAttributePersistenceStrategy strategy = this.persistenceStrategy;
        ClassLoader containerLoader = HotRodSessionManagerFactory.class.getClassLoader();
        Configuration configuration = Optional.ofNullable(this.uri).map(HotRodURI::create).map(HotRodURI::toConfigurationBuilder).orElseGet(ConfigurationBuilder::new).withProperties(this.properties).marshaller((Marshaller)new ProtoStreamMarshaller(ClassLoaderMarshaller.of((ClassLoader)containerLoader), builder -> builder.load(containerLoader))).build();
        configuration.addRemoteCache(deploymentName, builder -> builder.forceReturnValues(false).nearCacheMode(maxActiveSessions.isPresent() ? NearCacheMode.INVALIDATED : NearCacheMode.DISABLED).transactionMode(TransactionMode.NONE).templateName(this.templateName));
        RemoteCacheManager container = new RemoteCacheManager(configuration);
        container.start();
        this.stopTasks.add(() -> ((RemoteCacheContainer)container).stop());
        ClassLoader loader = context.getLoader().getClassLoader();
        final ByteBufferMarshaller marshaller = (ByteBufferMarshaller)this.marshallerFactory.apply(arg_0 -> ((ServletContext)servletContext).getInitParameter(arg_0), (Object)loader);
        LinkedList<Immutability> loadedImmutabilities = new LinkedList<Immutability>();
        for (Immutability loadedImmutability : ServiceLoader.load(Immutability.class, loader)) {
            loadedImmutabilities.add(loadedImmutability);
        }
        final Immutability immutability = Immutability.composite((Collection)Stream.concat(Stream.of(Immutability.getDefault()), loadedImmutabilities.stream()).collect(Collectors.toList()));
        SessionManagerFactoryConfiguration<CatalinaSessionContext> sessionManagerFactoryConfig = new SessionManagerFactoryConfiguration<CatalinaSessionContext>(){

            public OptionalInt getMaxActiveSessions() {
                return maxActiveSessions;
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategy;
            }

            public String getDeploymentName() {
                return deploymentName;
            }

            public ByteBufferMarshaller getMarshaller() {
                return marshaller;
            }

            public String getServerName() {
                return engine.getService().getName();
            }

            public Supplier<CatalinaSessionContext> getSessionContextFactory() {
                return CatalinaSessionContext::new;
            }

            public Immutability getImmutability() {
                return immutability;
            }
        };
        final RemoteCache cache = container.getCache(deploymentName);
        cache.start();
        this.stopTasks.add(() -> ((RemoteCache)cache).stop());
        RemoteCacheConfiguration hotrod = new RemoteCacheConfiguration(){

            public <K, V> RemoteCache<K, V> getCache() {
                return cache;
            }
        };
        HotRodSessionManagerFactory managerFactory = new HotRodSessionManagerFactory((SessionManagerFactoryConfiguration)sessionManagerFactoryConfig, (SessionSpecificationProvider)HttpSessionProvider.INSTANCE, (SessionEventListenerSpecificationProvider)HttpSessionActivationListenerProvider.INSTANCE, hotrod);
        this.stopTasks.add(() -> ((SessionManagerFactory)managerFactory).close());
        CatalinaSessionExpirationListener expirationListener = new CatalinaSessionExpirationListener(context);
        CatalinaIdentifierFactory identifierFactory = new CatalinaIdentifierFactory(this.getSessionIdGenerator());
        SessionManagerConfiguration<ServletContext> sessionManagerConfiguration = new SessionManagerConfiguration<ServletContext>((Supplier)identifierFactory, (Consumer)expirationListener){
            final /* synthetic */ Supplier val$identifierFactory;
            final /* synthetic */ Consumer val$expirationListener;
            {
                this.val$identifierFactory = supplier;
                this.val$expirationListener = consumer;
            }

            public ServletContext getContext() {
                return servletContext;
            }

            public ToIntFunction<ServletContext> getSessionTimeoutFunction() {
                return SESSION_TIMEOUT_FUNCTION;
            }

            public Supplier<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }

            public Consumer<ImmutableSession> getExpirationListener() {
                return this.val$expirationListener;
            }
        };
        SessionManager sessionManager = managerFactory.createSessionManager((org.wildfly.clustering.session.SessionManagerConfiguration)sessionManagerConfiguration);
        this.manager = new DistributableManager(sessionManager, context, (Marshallability)marshaller);
        this.manager.start();
        this.setState(LifecycleState.STARTING);
    }

    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        Optional.ofNullable(this.manager).ifPresent(CatalinaManager::stop);
        ListIterator<Runnable> tasks = this.stopTasks.listIterator(this.stopTasks.size());
        while (tasks.hasPrevious()) {
            tasks.previous().run();
            tasks.remove();
        }
        super.stopInternal();
    }

    public Session createSession(String sessionId) {
        return this.manager.createSession(sessionId);
    }

    public Session findSession(String id) throws IOException {
        return this.manager.findSession(id);
    }

    public void changeSessionId(Session session, String newId) {
        this.manager.changeSessionId(session, newId);
    }

    public boolean willAttributeDistribute(String name, Object value) {
        return this.manager.willAttributeDistribute(name, value);
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void backgroundProcess() {
    }

    public void processExpires() {
        throw new UnsupportedOperationException();
    }

    public void add(Session session) {
        throw new UnsupportedOperationException();
    }

    public Session createEmptySession() {
        throw new UnsupportedOperationException();
    }

    public Session[] findSessions() {
        throw new UnsupportedOperationException();
    }

    public void remove(Session session) {
        throw new UnsupportedOperationException();
    }

    public void remove(Session session, boolean update) {
        throw new UnsupportedOperationException();
    }

    public String listSessionIds() {
        throw new UnsupportedOperationException();
    }

    public String getSessionAttribute(String sessionId, String key) {
        throw new UnsupportedOperationException();
    }

    public HashMap<String, String> getSession(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public void expireSession(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public long getThisAccessedTimestamp(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public String getThisAccessedTime(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public long getLastAccessedTimestamp(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public String getLastAccessedTime(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public String getCreationTime(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public long getCreationTimestamp(String sessionId) {
        throw new UnsupportedOperationException();
    }
}

