/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.SessionListener;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSession;
import org.wildfly.clustering.tomcat.catalina.HttpSessionAdapter;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContext;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.oob.OOBSession;

public class DistributableSession<B extends Batch>
implements CatalinaSession {
    private final CatalinaManager<B> manager;
    private final AtomicReference<Session<LocalSessionContext>> session;
    private final String internalId;
    private final B batch;
    private final Runnable invalidateAction;
    private final Runnable closeTask;
    private final Instant startTime;

    public DistributableSession(CatalinaManager<B> manager, Session<LocalSessionContext> session, String internalId, B batch, Runnable invalidateAction, Runnable closeTask) {
        this.manager = manager;
        this.session = new AtomicReference<Session<LocalSessionContext>>(session);
        this.internalId = internalId;
        this.batch = batch;
        this.invalidateAction = invalidateAction;
        this.closeTask = closeTask;
        this.startTime = session.getMetaData().isNew() ? session.getMetaData().getCreationTime() : Instant.now();
    }

    public String getAuthType() {
        return ((LocalSessionContext)this.session.get().getLocalContext()).getAuthType();
    }

    public void setAuthType(String authType) {
        ((LocalSessionContext)this.session.get().getLocalContext()).setAuthType(authType);
    }

    public long getCreationTime() {
        long l;
        block8: {
            Session<LocalSessionContext> session = this.session.get();
            BatchContext context = this.resumeBatch();
            try {
                l = session.getMetaData().getCreationTime().toEpochMilli();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid(session);
                    throw e;
                }
            }
            context.close();
        }
        return l;
    }

    public String getId() {
        return this.session.get().getId();
    }

    public String getIdInternal() {
        return this.internalId;
    }

    public long getLastAccessedTime() {
        long l;
        block8: {
            Session<LocalSessionContext> session = this.session.get();
            BatchContext context = this.resumeBatch();
            try {
                l = session.getMetaData().getLastAccessStartTime().toEpochMilli();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid(session);
                    throw e;
                }
            }
            context.close();
        }
        return l;
    }

    public Manager getManager() {
        return this.manager;
    }

    public int getMaxInactiveInterval() {
        int n;
        block8: {
            Session<LocalSessionContext> session = this.session.get();
            BatchContext context = this.resumeBatch();
            try {
                n = (int)session.getMetaData().getMaxInactiveInterval().getSeconds();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid(session);
                    throw e;
                }
            }
            context.close();
        }
        return n;
    }

    public void setMaxInactiveInterval(int interval) {
        Session<LocalSessionContext> session = this.session.get();
        try (BatchContext context = this.resumeBatch();){
            session.getMetaData().setMaxInactiveInterval(interval > 0 ? Duration.ofSeconds(interval) : Duration.ZERO);
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(session);
            throw e;
        }
    }

    public Principal getPrincipal() {
        return ((LocalSessionContext)this.session.get().getLocalContext()).getPrincipal();
    }

    public void setPrincipal(Principal principal) {
        ((LocalSessionContext)this.session.get().getLocalContext()).setPrincipal(principal);
    }

    public HttpSession getSession() {
        return new HttpSessionAdapter<B>(this.session, this.manager, this.batch, this.invalidateAction, this::closeIfInvalid);
    }

    public boolean isValid() {
        return this.session.get().isValid();
    }

    public void addSessionListener(SessionListener listener) {
        ((LocalSessionContext)this.session.get().getLocalContext()).getSessionListeners().add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAccess() {
        Batcher batcher = this.manager.getSessionManager().getBatcher();
        Session<LocalSessionContext> requestSession = this.session.get();
        try (BatchContext context = batcher.resumeBatch(this.batch);){
            if (this.batch.getState() == Batch.State.DISCARDED) {
                this.batch.close();
            }
            try (B batch = this.batch.getState() == Batch.State.CLOSED && requestSession.isValid() ? batcher.createBatch() : this.batch;
                 Session<LocalSessionContext> session = requestSession;){
                if (session.isValid()) {
                    session.getMetaData().setLastAccess(this.startTime, Instant.now());
                }
            }
        }
        catch (Throwable e) {
            this.manager.getContext().getLogger().warn((Object)e.getLocalizedMessage(), e);
        }
        finally {
            this.session.set((Session<LocalSessionContext>)new OOBSession(this.manager.getSessionManager(), requestSession.getId(), (Object)((LocalSessionContext)requestSession.getLocalContext())));
            this.closeTask.run();
        }
    }

    public void expire() {
        throw new IllegalStateException();
    }

    public Object getNote(String name) {
        return ((LocalSessionContext)this.session.get().getLocalContext()).getNotes().get(name);
    }

    public Iterator<String> getNoteNames() {
        return ((LocalSessionContext)this.session.get().getLocalContext()).getNotes().keySet().iterator();
    }

    public void removeNote(String name) {
        ((LocalSessionContext)this.session.get().getLocalContext()).getNotes().remove(name);
    }

    public void removeSessionListener(SessionListener listener) {
        ((LocalSessionContext)this.session.get().getLocalContext()).getSessionListeners().remove(listener);
    }

    public void setNote(String name, Object value) {
        ((LocalSessionContext)this.session.get().getLocalContext()).getNotes().put(name, value);
    }

    public void tellChangedSessionId(String newId, String oldId, boolean notifySessionListeners, boolean notifyContainerListeners) {
        Session<LocalSessionContext> oldSession = this.session.get();
        try (BatchContext context = this.resumeBatch();){
            Session newSession = this.manager.getSessionManager().createSession(newId);
            try {
                for (String name : oldSession.getAttributes().getAttributeNames()) {
                    newSession.getAttributes().setAttribute(name, oldSession.getAttributes().getAttribute(name));
                }
                newSession.getMetaData().setMaxInactiveInterval(oldSession.getMetaData().getMaxInactiveInterval());
                newSession.getMetaData().setLastAccess(oldSession.getMetaData().getLastAccessStartTime(), oldSession.getMetaData().getLastAccessEndTime());
                ((LocalSessionContext)newSession.getLocalContext()).setAuthType(((LocalSessionContext)oldSession.getLocalContext()).getAuthType());
                ((LocalSessionContext)newSession.getLocalContext()).setPrincipal(((LocalSessionContext)oldSession.getLocalContext()).getPrincipal());
                oldSession.invalidate();
                this.session.set((Session<LocalSessionContext>)newSession);
            }
            catch (IllegalStateException e) {
                this.closeIfInvalid(oldSession);
                newSession.invalidate();
            }
        }
        context = this.manager.getContext();
        if (notifyContainerListeners) {
            context.fireContainerEvent("changeSessionId", (Object)new String[]{oldId, newId});
        }
        if (notifySessionListeners) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            Stream.of(context.getApplicationEventListeners()).filter(listener -> listener instanceof HttpSessionIdListener).map(listener -> (HttpSessionIdListener)listener).forEach(arg_0 -> DistributableSession.lambda$tellChangedSessionId$2(event, oldId, (Context)context, arg_0));
        }
    }

    public boolean isAttributeDistributable(String name, Object value) {
        return this.manager.getMarshallability().isMarshallable(value);
    }

    private BatchContext resumeBatch() {
        Batch batch = this.batch.getState() != Batch.State.CLOSED ? (Batch)this.batch : null;
        return this.manager.getSessionManager().getBatcher().resumeBatch(batch);
    }

    private void closeIfInvalid(Session<LocalSessionContext> session) {
        if (!session.isValid()) {
            try {
                session.close();
            }
            finally {
                this.closeTask.run();
            }
        }
    }

    private static /* synthetic */ void lambda$tellChangedSessionId$2(HttpSessionEvent event, String oldId, Context context, HttpSessionIdListener listener) {
        try {
            listener.sessionIdChanged(event, oldId);
        }
        catch (Throwable e) {
            context.getLogger().warn((Object)e.getMessage(), e);
        }
    }
}

