/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.wildfly.clustering.tomcat.catalina.AbstractHttpSession;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SpecificationProvider;

public enum CatalinaSpecificationProvider implements SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener>
{
    INSTANCE;


    public HttpSession createHttpSession(final ImmutableSession session, final ServletContext context) {
        return new AbstractHttpSession(){

            public String getId() {
                return session.getId();
            }

            public ServletContext getServletContext() {
                return context;
            }

            public boolean isNew() {
                return session.getMetaData().isNew();
            }

            public long getCreationTime() {
                return session.getMetaData().getCreationTime().toEpochMilli();
            }

            public long getLastAccessedTime() {
                return session.getMetaData().getLastAccessStartTime().toEpochMilli();
            }

            public int getMaxInactiveInterval() {
                return (int)session.getMetaData().getTimeout().getSeconds();
            }

            public Enumeration<String> getAttributeNames() {
                return Collections.enumeration(session.getAttributes().getAttributeNames());
            }

            public Object getAttribute(String name) {
                return session.getAttributes().getAttribute(name);
            }

            public void setAttribute(String name, Object value) {
            }

            public void removeAttribute(String name) {
            }

            public void invalidate() {
            }

            public void setMaxInactiveInterval(int interval) {
            }
        };
    }

    public Class<HttpSessionActivationListener> getHttpSessionActivationListenerClass() {
        return HttpSessionActivationListener.class;
    }

    public Consumer<HttpSession> prePassivateNotifier(final HttpSessionActivationListener listener) {
        return new Consumer<HttpSession>(){

            @Override
            public void accept(HttpSession session) {
                listener.sessionWillPassivate(new HttpSessionEvent(session));
            }
        };
    }

    public Consumer<HttpSession> postActivateNotifier(final HttpSessionActivationListener listener) {
        return new Consumer<HttpSession>(){

            @Override
            public void accept(HttpSession session) {
                listener.sessionDidActivate(new HttpSessionEvent(session));
            }
        };
    }

    public HttpSessionActivationListener createListener(final Consumer<HttpSession> prePassivate, final Consumer<HttpSession> postActivate) {
        return new HttpSessionActivationListener(){

            public void sessionWillPassivate(HttpSessionEvent event) {
                prePassivate.accept(event.getSession());
            }

            public void sessionDidActivate(HttpSessionEvent event) {
                postActivate.accept(event.getSession());
            }
        };
    }
}

