/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.hotrod;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.wildfly.clustering.infinispan.client.near.CaffeineNearCache;
import org.wildfly.clustering.infinispan.client.near.SimpleKeyWeigher;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;

public class SessionManagerNearCacheFactory
implements NearCacheFactory {
    private final Integer maxActiveSessions;
    private final SessionAttributePersistenceStrategy strategy;

    public SessionManagerNearCacheFactory(Integer maxActiveSessions, SessionAttributePersistenceStrategy strategy) {
        this.maxActiveSessions = maxActiveSessions;
        this.strategy = strategy;
    }

    public <K, V> NearCache<K, V> createNearCache(NearCacheConfiguration config) {
        AtomicReference reference = new AtomicReference();
        Caffeine builder = Caffeine.newBuilder();
        if (this.maxActiveSessions != null) {
            builder.executor(Runnable::run).maximumWeight(this.maxActiveSessions.longValue()).weigher((Weigher)new SimpleKeyWeigher(SessionCreationMetaDataKey.class::isInstance)).removalListener(new CascadeRemovalListener(this.strategy, reference));
        }
        Cache cache = builder.build();
        reference.set(cache);
        return new CaffeineNearCache(cache);
    }

    private static class CascadeRemovalListener<K, V>
    implements RemovalListener<Object, Object> {
        private final AtomicReference<Cache<K, MetadataValue<V>>> reference;
        private final SessionAttributePersistenceStrategy strategy;

        CascadeRemovalListener(SessionAttributePersistenceStrategy strategy, AtomicReference<Cache<K, MetadataValue<V>>> reference) {
            this.strategy = strategy;
            this.reference = reference;
        }

        public void onRemoval(Object key, Object value, RemovalCause cause) {
            if (cause == RemovalCause.SIZE && key instanceof SessionCreationMetaDataKey) {
                String id = (String)((SessionCreationMetaDataKey)key).getId();
                Cache<K, MetadataValue<V>> cache = this.reference.get();
                LinkedList<Object> keys = new LinkedList<Object>();
                keys.add(new SessionAccessMetaDataKey(id));
                switch (this.strategy) {
                    case COARSE: {
                        keys.add(new SessionAttributesKey(id));
                        break;
                    }
                    case FINE: {
                        SessionAttributeNamesKey namesKey = new SessionAttributeNamesKey(id);
                        keys.add(namesKey);
                        MetadataValue namesValue = (MetadataValue)cache.getIfPresent((Object)namesKey);
                        if (namesValue == null) break;
                        Map names = (Map)namesValue.getValue();
                        for (UUID attributeId : names.values()) {
                            keys.add(new SessionAttributeKey(id, attributeId));
                        }
                        break;
                    }
                }
                cache.invalidateAll(keys);
            }
        }
    }
}

