/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.hotrod;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.commons.marshall.jboss.DefaultContextClassResolver;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleClassTable;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionExpirationListener;
import org.wildfly.clustering.tomcat.catalina.DistributableManager;
import org.wildfly.clustering.tomcat.catalina.IdentifierFactoryAdapter;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContext;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContextFactory;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.RemoteCacheContainerConfiguration;
import org.wildfly.clustering.web.hotrod.RemoteCacheContainerFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class HotRodManager
extends ManagerBase
implements RemoteCacheContainerConfiguration {
    private final Supplier<RemoteCacheContainer> factory = new RemoteCacheContainerFactory((RemoteCacheContainerConfiguration)this);
    private final Properties properties = new Properties();
    private volatile RemoteCacheContainer container;
    private volatile SessionManagerFactory<LocalSessionContext, TransactionBatch> managerFactory;
    private volatile CatalinaManager<TransactionBatch> manager;
    private volatile SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy persistenceStrategy = SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy.COARSE;

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty("infinispan.client.hotrod." + name, value);
    }

    public void setPersistenceStrategy(SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy strategy) {
        this.persistenceStrategy = strategy;
    }

    public void setPersistenceStrategy(String strategy) {
        this.setPersistenceStrategy(SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy.valueOf((String)strategy));
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        RemoteCacheContainer container = this.factory.get();
        container.start();
        this.container = container;
        Context context = this.getContext();
        ClassLoader loader = context.getLoader().getClassLoader();
        Host host = (Host)context.getParent();
        Engine engine = (Engine)host.getParent();
        final String deploymentName = host.getName() + context.getName();
        final int maxActiveSessions = this.getMaxActiveSessions();
        final SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy strategy = this.persistenceStrategy;
        SimpleMarshallingContext marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)loader), loader);
        SimpleMarshalledValueFactory marshallingFactory = new SimpleMarshalledValueFactory((MarshallingContext)marshallingContext);
        LocalSessionContextFactory localContextFactory = new LocalSessionContextFactory();
        HotRodSessionManagerFactoryConfiguration<MarshallingContext, LocalSessionContext> sessionManagerFactoryConfig = new HotRodSessionManagerFactoryConfiguration<MarshallingContext, LocalSessionContext>((MarshalledValueFactory)marshallingFactory, (MarshallingContext)marshallingContext, engine, (LocalContextFactory)localContextFactory, container){
            final /* synthetic */ MarshalledValueFactory val$marshallingFactory;
            final /* synthetic */ MarshallingContext val$marshallingContext;
            final /* synthetic */ Engine val$engine;
            final /* synthetic */ LocalContextFactory val$localContextFactory;
            final /* synthetic */ RemoteCacheContainer val$container;
            {
                this.val$marshallingFactory = marshalledValueFactory;
                this.val$marshallingContext = marshallingContext;
                this.val$engine = engine;
                this.val$localContextFactory = localContextFactory;
                this.val$container = remoteCacheContainer;
            }

            public int getMaxActiveSessions() {
                return maxActiveSessions;
            }

            public SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategy;
            }

            public String getDeploymentName() {
                return deploymentName;
            }

            public String getCacheName() {
                return null;
            }

            public MarshalledValueFactory<MarshallingContext> getMarshalledValueFactory() {
                return this.val$marshallingFactory;
            }

            public MarshallingContext getMarshallingContext() {
                return this.val$marshallingContext;
            }

            public String getServerName() {
                return this.val$engine.getService().getName();
            }

            public LocalContextFactory<LocalSessionContext> getLocalContextFactory() {
                return this.val$localContextFactory;
            }

            public <K, V> RemoteCache<K, V> getCache() {
                return this.val$container.getCache(true);
            }
        };
        this.managerFactory = new HotRodSessionManagerFactory((HotRodSessionManagerFactoryConfiguration)sessionManagerFactoryConfig);
        final ServletContext servletContext = context.getServletContext();
        CatalinaSessionExpirationListener expirationListener = new CatalinaSessionExpirationListener(context);
        IdentifierFactoryAdapter identifierFactory = new IdentifierFactoryAdapter(this.getSessionIdGenerator());
        SessionManagerConfiguration sessionManagerConfiguration = new SessionManagerConfiguration((IdentifierFactory)identifierFactory, (SessionExpirationListener)expirationListener){
            final /* synthetic */ IdentifierFactory val$identifierFactory;
            final /* synthetic */ SessionExpirationListener val$expirationListener;
            {
                this.val$identifierFactory = identifierFactory;
                this.val$expirationListener = sessionExpirationListener;
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }

            public SessionExpirationListener getExpirationListener() {
                return this.val$expirationListener;
            }

            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return null;
            }
        };
        SessionManager sessionManager = this.managerFactory.createSessionManager(sessionManagerConfiguration);
        this.manager = new DistributableManager(sessionManager, context, (Marshallability)marshallingContext);
        this.manager.start();
        this.setState(LifecycleState.STARTING);
    }

    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.manager.stop();
        this.managerFactory.close();
        this.container.stop();
    }

    public Session createSession(String sessionId) {
        return this.manager.createSession(sessionId);
    }

    public Session findSession(String id) throws IOException {
        return this.manager.findSession(id);
    }

    public void changeSessionId(Session session) {
        this.manager.changeSessionId(session);
    }

    public void changeSessionId(Session session, String newId) {
        this.manager.changeSessionId(session, newId);
    }

    public boolean willAttributeDistribute(String name, Object value) {
        return this.manager.willAttributeDistribute(name, value);
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void backgroundProcess() {
    }

    public void processExpires() {
        throw new UnsupportedOperationException();
    }

    public void add(Session session) {
        throw new UnsupportedOperationException();
    }

    public Session createEmptySession() {
        throw new UnsupportedOperationException();
    }

    public Session[] findSessions() {
        throw new UnsupportedOperationException();
    }

    public void remove(Session session) {
        throw new UnsupportedOperationException();
    }

    public void remove(Session session, boolean update) {
        throw new UnsupportedOperationException();
    }

    public String listSessionIds() {
        throw new UnsupportedOperationException();
    }

    public String getSessionAttribute(String sessionId, String key) {
        throw new UnsupportedOperationException();
    }

    public HashMap<String, String> getSession(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public void expireSession(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public long getThisAccessedTimestamp(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public String getThisAccessedTime(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public long getLastAccessedTimestamp(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public String getLastAccessedTime(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public String getCreationTime(String sessionId) {
        throw new UnsupportedOperationException();
    }

    public long getCreationTimestamp(String sessionId) {
        throw new UnsupportedOperationException();
    }

    static enum MarshallingVersion implements Function<ClassLoader, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(ClassLoader loader) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)new DefaultContextClassResolver(loader));
                config.setClassTable((ClassTable)new SimpleClassTable(new Class[]{Serializable.class, Externalizable.class}));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable(loader));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_1;
        }
    }
}

