/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.catalina.Context;
import org.apache.catalina.valves.CrawlerSessionManagerValve;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.tomcat.catalina.AbstractHttpSession;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContext;
import org.wildfly.clustering.web.session.Session;

public class HttpSessionAdapter<B extends Batch>
extends AbstractHttpSession {
    private static final Set<String> EXCLUDED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("javax.security.auth.subject", "org.apache.catalina.realm.GSS_CREDENTIAL", CrawlerSessionManagerValve.class.getName())));
    private final AtomicReference<Session<LocalSessionContext>> session;
    private final CatalinaManager<B> manager;
    private final B batch;
    private final Runnable invalidateAction;
    private final Consumer<Session<LocalSessionContext>> closeIfInvalid;

    public HttpSessionAdapter(AtomicReference<Session<LocalSessionContext>> session, CatalinaManager<B> manager, B batch, Runnable invalidateAction, Consumer<Session<LocalSessionContext>> closeIfInvalid) {
        this.session = session;
        this.manager = manager;
        this.batch = batch;
        this.invalidateAction = invalidateAction;
        this.closeIfInvalid = closeIfInvalid;
    }

    public boolean isNew() {
        boolean bl;
        block8: {
            Session<LocalSessionContext> session = this.session.get();
            BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);
            try {
                bl = session.getMetaData().isNew();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid.accept(session);
                    throw e;
                }
            }
            context.close();
        }
        return bl;
    }

    public long getCreationTime() {
        long l;
        block8: {
            Session<LocalSessionContext> session = this.session.get();
            BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);
            try {
                l = session.getMetaData().getCreationTime().toEpochMilli();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid.accept(session);
                    throw e;
                }
            }
            context.close();
        }
        return l;
    }

    public long getLastAccessedTime() {
        long l;
        block8: {
            Session<LocalSessionContext> session = this.session.get();
            BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);
            try {
                l = session.getMetaData().getLastAccessStartTime().toEpochMilli();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid.accept(session);
                    throw e;
                }
            }
            context.close();
        }
        return l;
    }

    public int getMaxInactiveInterval() {
        int n;
        block8: {
            Session<LocalSessionContext> session = this.session.get();
            BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);
            try {
                n = (int)session.getMetaData().getMaxInactiveInterval().getSeconds();
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid.accept(session);
                    throw e;
                }
            }
            context.close();
        }
        return n;
    }

    public void setMaxInactiveInterval(int interval) {
        Session<LocalSessionContext> session = this.session.get();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            session.getMetaData().setMaxInactiveInterval(interval > 0 ? Duration.ofSeconds(interval) : Duration.ZERO);
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid.accept(session);
            throw e;
        }
    }

    public void invalidate() {
        this.invalidateAction.run();
        Session<LocalSessionContext> session = this.session.get();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
            session.invalidate();
            this.batch.close();
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid.accept(session);
            throw e;
        }
    }

    public Object getAttribute(String name) {
        Object object;
        block9: {
            Session<LocalSessionContext> session = this.session.get();
            if (EXCLUDED_ATTRIBUTES.contains(name)) {
                return ((LocalSessionContext)session.getLocalContext()).getNotes().get(name);
            }
            ((LocalSessionContext)session.getLocalContext()).getNotes().get(name);
            BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);
            try {
                object = session.getAttributes().getAttribute(name);
                if (context == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid.accept(session);
                    throw e;
                }
            }
            context.close();
        }
        return object;
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration<String> enumeration;
        block8: {
            Session<LocalSessionContext> session = this.session.get();
            BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);
            try {
                enumeration = Collections.enumeration(session.getAttributes().getAttributeNames());
                if (context == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid.accept(session);
                    throw e;
                }
            }
            context.close();
        }
        return enumeration;
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            Session<LocalSessionContext> session = this.session.get();
            if (EXCLUDED_ATTRIBUTES.contains(name)) {
                ((LocalSessionContext)session.getLocalContext()).getNotes().put(name, value);
            } else {
                Object old = null;
                try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
                    old = session.getAttributes().setAttribute(name, value);
                }
                catch (IllegalStateException e) {
                    this.closeIfInvalid.accept(session);
                    throw e;
                }
                if (old != value) {
                    this.notifySessionAttributeListeners(name, old, value);
                }
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        Session<LocalSessionContext> session = this.session.get();
        if (EXCLUDED_ATTRIBUTES.contains(name)) {
            ((LocalSessionContext)session.getLocalContext()).getNotes().remove(name);
        } else {
            Object value = null;
            try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);){
                value = session.getAttributes().removeAttribute(name);
            }
            catch (IllegalStateException e) {
                this.closeIfInvalid.accept(session);
                throw e;
            }
            if (value != null) {
                this.notifySessionAttributeListeners(name, value, null);
            }
        }
    }

    private void notifySessionAttributeListeners(String name, Object oldValue, Object newValue) {
        HttpSessionBindingListener listener;
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            try {
                listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            catch (Throwable e) {
                this.manager.getContext().getLogger().warn((Object)e.getMessage(), e);
            }
        }
        if (newValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)newValue;
            try {
                listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            catch (Throwable e) {
                this.manager.getContext().getLogger().warn((Object)e.getMessage(), e);
            }
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue != null ? oldValue : newValue);
        AttributeEventType type = oldValue == null ? AttributeEventType.ADDED : (newValue == null ? AttributeEventType.REMOVED : AttributeEventType.REPLACED);
        type.accept(this.manager.getContext(), event);
    }

    public String getId() {
        return this.session.get().getId();
    }

    public ServletContext getServletContext() {
        return this.manager.getContext().getServletContext();
    }

    static enum AttributeEventType implements BiConsumer<Context, HttpSessionBindingEvent>
    {
        ADDED("beforeSessionAttributeAdded", "afterSessionAttributeAdded", (listener, event) -> listener.attributeAdded(event)),
        REMOVED("beforeSessionAttributeRemoved", "afterSessionAttributeRemoved", (listener, event) -> listener.attributeRemoved(event)),
        REPLACED("beforeSessionAttributeReplaced", "afterSessionAttributeReplaced", (listener, event) -> listener.attributeReplaced(event));

        private final String beforeEvent;
        private final String afterEvent;
        private final BiConsumer<HttpSessionAttributeListener, HttpSessionBindingEvent> trigger;

        private AttributeEventType(String beforeEvent, String afterEvent, BiConsumer<HttpSessionAttributeListener, HttpSessionBindingEvent> trigger) {
            this.beforeEvent = beforeEvent;
            this.afterEvent = afterEvent;
            this.trigger = trigger;
        }

        @Override
        public void accept(Context context, HttpSessionBindingEvent event) {
            Stream.of(context.getApplicationEventListeners()).filter(HttpSessionAttributeListener.class::isInstance).map(HttpSessionAttributeListener.class::cast).forEach(listener -> {
                try {
                    context.fireContainerEvent(this.beforeEvent, listener);
                    this.trigger.accept((HttpSessionAttributeListener)listener, event);
                }
                catch (Throwable e) {
                    context.getLogger().warn((Object)e.getMessage(), e);
                }
                finally {
                    context.fireContainerEvent(this.afterEvent, listener);
                }
            });
        }
    }
}

