/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.io.IOException;
import java.util.OptionalLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Session;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.marshalling.Marshallability;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.spec.servlet.HttpSessionProvider;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionContext;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionDestroyAction;
import org.wildfly.clustering.tomcat.catalina.DistributableSession;

public class DistributableManager<B extends Batch>
implements CatalinaManager<B> {
    private static final char ROUTE_DELIMITER = '.';
    private final SessionManager<CatalinaSessionContext, B> manager;
    private final Context context;
    private final Consumer<ImmutableSession> invalidateAction;
    private final Marshallability marshallability;
    private final String route;
    private final StampedLock lifecycleLock = new StampedLock();
    private OptionalLong lifecycleStamp = OptionalLong.empty();

    public DistributableManager(SessionManager<CatalinaSessionContext, B> manager, Context context, Marshallability marshallability) {
        this.manager = manager;
        this.marshallability = marshallability;
        this.context = context;
        this.route = ((Engine)context.getParent().getParent()).getJvmRoute();
        this.invalidateAction = new CatalinaSessionDestroyAction(context);
    }

    @Override
    public SessionManager<CatalinaSessionContext, B> getSessionManager() {
        return this.manager;
    }

    @Override
    public Marshallability getMarshallability() {
        return this.marshallability;
    }

    private static String parseSessionId(String requestedSesssionId) {
        int index = requestedSesssionId.indexOf(46);
        return index < 0 ? requestedSesssionId : requestedSesssionId.substring(0, index);
    }

    private Session getSession(org.wildfly.clustering.session.Session<CatalinaSessionContext> session) {
        String id = session.getId();
        String internalId = this.route != null ? new StringBuilder(id.length() + this.route.length() + 1).append(id).append('.').append(this.route).toString() : id;
        return new DistributableSession<Batch>(this, session, internalId, this.manager.getBatcher().suspendBatch(), () -> this.invalidateAction.accept((ImmutableSession)session));
    }

    @Override
    public void start() {
        this.lifecycleStamp.ifPresent(stamp -> this.lifecycleLock.unlock(stamp));
        this.manager.start();
    }

    @Override
    public void stop() {
        if (!this.lifecycleStamp.isPresent()) {
            try {
                this.lifecycleStamp = OptionalLong.of(this.lifecycleLock.writeLockInterruptibly());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.manager.stop();
        }
    }

    public Session createSession(String sessionId) {
        String id = sessionId != null ? DistributableManager.parseSessionId(sessionId) : (String)this.manager.getIdentifierFactory().get();
        boolean close = true;
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            org.wildfly.clustering.session.Session session = this.manager.createSession(id);
            HttpSessionEvent event = new HttpSessionEvent(HttpSessionProvider.INSTANCE.asSession((ImmutableSession)session, this.context.getServletContext()));
            Stream.of(this.context.getApplicationLifecycleListeners()).filter(HttpSessionListener.class::isInstance).map(HttpSessionListener.class::cast).forEach(listener -> {
                try {
                    this.context.fireContainerEvent("beforeSessionCreated", listener);
                    listener.sessionCreated(event);
                }
                catch (Throwable e) {
                    this.context.getLogger().warn((Object)e.getMessage(), e);
                }
                finally {
                    this.context.fireContainerEvent("afterSessionCreated", listener);
                }
            });
            Session result = this.getSession((org.wildfly.clustering.session.Session<CatalinaSessionContext>)session);
            close = false;
            Session session2 = result;
            return session2;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (close) {
                batch.close();
            }
        }
    }

    public Session findSession(String sessionId) throws IOException {
        String id = DistributableManager.parseSessionId(sessionId);
        boolean close = true;
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            org.wildfly.clustering.session.Session session = this.manager.findSession(id);
            if (session == null) {
                Session session2 = null;
                return session2;
            }
            Session result = this.getSession((org.wildfly.clustering.session.Session<CatalinaSessionContext>)session);
            close = false;
            Session session3 = result;
            return session3;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (close) {
                batch.close();
            }
        }
    }

    public void changeSessionId(Session session) {
        this.changeSessionId(session, (String)this.manager.getIdentifierFactory().get());
    }

    public void changeSessionId(Session session, String id) {
        session.tellChangedSessionId(id, session.getId(), true, true);
    }

    public Context getContext() {
        return this.context;
    }

    public boolean willAttributeDistribute(String name, Object value) {
        return this.marshallability.isMarshallable(value);
    }

    public boolean getNotifyAttributeListenerOnUnchangedValue() {
        return false;
    }
}

