/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.catalina.Context;
import org.apache.catalina.valves.CrawlerSessionManagerValve;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.tomcat.catalina.AbstractHttpSession;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionContext;

public class HttpSessionAdapter<B extends Batch>
extends AbstractHttpSession {
    private static final Set<String> EXCLUDED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("javax.security.auth.subject", "org.apache.catalina.realm.GSS_CREDENTIAL", CrawlerSessionManagerValve.class.getName())));
    private final AtomicReference<Session<CatalinaSessionContext>> session;
    private final CatalinaManager<B> manager;
    private final B batch;
    private final Runnable invalidateAction;

    public HttpSessionAdapter(AtomicReference<Session<CatalinaSessionContext>> session, CatalinaManager<B> manager, B batch, Runnable invalidateAction) {
        this.session = session;
        this.manager = manager;
        this.batch = batch;
        this.invalidateAction = invalidateAction;
    }

    public boolean isNew() {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            return session.getMetaData().isNew();
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public long getCreationTime() {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            return session.getMetaData().getCreationTime().toEpochMilli();
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public long getLastAccessedTime() {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            return session.getMetaData().getLastAccessStartTime().toEpochMilli();
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public int getMaxInactiveInterval() {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            return (int)session.getMetaData().getTimeout().getSeconds();
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public void setMaxInactiveInterval(int interval) {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            session.getMetaData().setTimeout(interval > 0 ? Duration.ofSeconds(interval) : Duration.ZERO);
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public void invalidate() {
        this.invalidateAction.run();
        Session<CatalinaSessionContext> session = this.session.get();
        try (BatchContext context = this.manager.getSessionManager().getBatcher().resumeBatch(this.batch);
             Batch batch = context.getBatch();){
            session.invalidate();
            session.close();
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public Object getAttribute(String name) {
        Session<CatalinaSessionContext> session = this.session.get();
        if (EXCLUDED_ATTRIBUTES.contains(name)) {
            return ((CatalinaSessionContext)session.getContext()).getNotes().get(name);
        }
        try {
            return session.getAttributes().get(name);
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public Enumeration<String> getAttributeNames() {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            return Collections.enumeration(session.getAttributes().keySet());
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(String name, Object value) {
        if (value != null) {
            Session<CatalinaSessionContext> session = this.session.get();
            if (EXCLUDED_ATTRIBUTES.contains(name)) {
                ((CatalinaSessionContext)session.getContext()).getNotes().put(name, value);
                return;
            } else {
                try {
                    Object old = session.getAttributes().put(name, value);
                    if (old == value) return;
                    this.notifySessionAttributeListeners(name, old, value);
                    return;
                }
                catch (IllegalStateException e) {
                    if (session.isValid()) throw e;
                    session.close();
                    throw e;
                }
            }
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        Session<CatalinaSessionContext> session = this.session.get();
        if (EXCLUDED_ATTRIBUTES.contains(name)) {
            ((CatalinaSessionContext)session.getContext()).getNotes().remove(name);
        } else {
            try {
                Object value = session.getAttributes().remove(name);
                if (value != null) {
                    this.notifySessionAttributeListeners(name, value, null);
                }
            }
            catch (IllegalStateException e) {
                if (!session.isValid()) {
                    session.close();
                }
                throw e;
            }
        }
    }

    private void notifySessionAttributeListeners(String name, Object oldValue, Object newValue) {
        HttpSessionBindingListener listener;
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            try {
                listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            catch (Throwable e) {
                this.manager.getContext().getLogger().warn((Object)e.getMessage(), e);
            }
        }
        if (newValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)newValue;
            try {
                listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
            catch (Throwable e) {
                this.manager.getContext().getLogger().warn((Object)e.getMessage(), e);
            }
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue != null ? oldValue : newValue);
        AttributeEventType type = oldValue == null ? AttributeEventType.ADDED : (newValue == null ? AttributeEventType.REMOVED : AttributeEventType.REPLACED);
        type.accept(this.manager.getContext(), event);
    }

    public String getId() {
        return this.session.get().getId();
    }

    public ServletContext getServletContext() {
        return this.manager.getContext().getServletContext();
    }

    static enum AttributeEventType implements BiConsumer<Context, HttpSessionBindingEvent>
    {
        ADDED("beforeSessionAttributeAdded", "afterSessionAttributeAdded", (listener, event) -> listener.attributeAdded(event)),
        REMOVED("beforeSessionAttributeRemoved", "afterSessionAttributeRemoved", (listener, event) -> listener.attributeRemoved(event)),
        REPLACED("beforeSessionAttributeReplaced", "afterSessionAttributeReplaced", (listener, event) -> listener.attributeReplaced(event));

        private final String beforeEvent;
        private final String afterEvent;
        private final BiConsumer<HttpSessionAttributeListener, HttpSessionBindingEvent> trigger;

        private AttributeEventType(String beforeEvent, String afterEvent, BiConsumer<HttpSessionAttributeListener, HttpSessionBindingEvent> trigger) {
            this.beforeEvent = beforeEvent;
            this.afterEvent = afterEvent;
            this.trigger = trigger;
        }

        @Override
        public void accept(Context context, HttpSessionBindingEvent event) {
            Stream.of(context.getApplicationEventListeners()).filter(HttpSessionAttributeListener.class::isInstance).map(HttpSessionAttributeListener.class::cast).forEach(listener -> {
                try {
                    context.fireContainerEvent(this.beforeEvent, listener);
                    this.trigger.accept((HttpSessionAttributeListener)listener, event);
                }
                catch (Throwable e) {
                    context.getLogger().warn((Object)e.getMessage(), e);
                }
                finally {
                    context.fireContainerEvent(this.afterEvent, listener);
                }
            });
        }
    }
}

