/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.catalina.Context;
import org.wildfly.clustering.context.ContextClassLoaderReference;
import org.wildfly.clustering.context.ContextualExecutor;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionDestroyAction;

public class CatalinaSessionExpirationListener
implements Consumer<ImmutableSession> {
    private final Consumer<ImmutableSession> expireAction;
    private final Executor executor;

    public CatalinaSessionExpirationListener(Context context) {
        this.expireAction = new CatalinaSessionDestroyAction(context);
        this.executor = ContextualExecutor.withContextProvider((Supplier)ContextClassLoaderReference.INSTANCE.provide((Object)context.getLoader().getClassLoader()));
    }

    @Override
    public void accept(ImmutableSession session) {
        this.executor.execute(() -> this.expireAction.accept(session));
    }
}

