/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.SessionListener;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSession;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionContext;
import org.wildfly.clustering.tomcat.catalina.HttpSessionAdapter;

public class DistributableSession
implements CatalinaSession {
    private final CatalinaManager manager;
    private final AtomicReference<Session<CatalinaSessionContext>> session;
    private final String internalId;
    private final SuspendedBatch batch;
    private final Runnable invalidateAction;
    private final Instant startTime;

    public DistributableSession(CatalinaManager manager, Session<CatalinaSessionContext> session, String internalId, SuspendedBatch batch, Runnable invalidateAction) {
        this.manager = manager;
        this.session = new AtomicReference<Session<CatalinaSessionContext>>(session);
        this.internalId = internalId;
        this.batch = batch;
        this.invalidateAction = invalidateAction;
        this.startTime = session.getMetaData().isNew() ? session.getMetaData().getCreationTime() : Instant.now();
    }

    public String getAuthType() {
        return ((CatalinaSessionContext)this.session.get().getContext()).getAuthType();
    }

    public void setAuthType(String authType) {
        ((CatalinaSessionContext)this.session.get().getContext()).setAuthType(authType);
    }

    public long getCreationTime() {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            return session.getMetaData().getCreationTime().toEpochMilli();
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public String getId() {
        return this.session.get().getId();
    }

    public String getIdInternal() {
        return this.internalId;
    }

    public long getLastAccessedTime() {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            return session.getMetaData().getLastAccessStartTime().toEpochMilli();
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public Manager getManager() {
        return this.manager;
    }

    public int getMaxInactiveInterval() {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            return (int)session.getMetaData().getTimeout().getSeconds();
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public void setMaxInactiveInterval(int interval) {
        Session<CatalinaSessionContext> session = this.session.get();
        try {
            session.getMetaData().setTimeout(interval > 0 ? Duration.ofSeconds(interval) : Duration.ZERO);
        }
        catch (IllegalStateException e) {
            if (!session.isValid()) {
                session.close();
            }
            throw e;
        }
    }

    public Principal getPrincipal() {
        return ((CatalinaSessionContext)this.session.get().getContext()).getPrincipal();
    }

    public void setPrincipal(Principal principal) {
        ((CatalinaSessionContext)this.session.get().getContext()).setPrincipal(principal);
    }

    public HttpSession getSession() {
        return new HttpSessionAdapter(this.session, this.manager, this.batch, this.invalidateAction);
    }

    public boolean isValid() {
        return this.session.get().isValid();
    }

    public void addSessionListener(SessionListener listener) {
        ((CatalinaSessionContext)this.session.get().getContext()).getSessionListeners().add(listener);
    }

    public void endAccess() {
        try (Batch batch = this.batch.resume();
             Session<CatalinaSessionContext> session = this.session.get();){
            if (session.isValid()) {
                session.getMetaData().setLastAccess(this.startTime, Instant.now());
            }
        }
        catch (Throwable e) {
            this.manager.getContext().getLogger().warn((Object)e.getLocalizedMessage(), e);
        }
    }

    public void expire() {
        throw new IllegalStateException();
    }

    public Object getNote(String name) {
        return ((CatalinaSessionContext)this.session.get().getContext()).getNotes().get(name);
    }

    public Iterator<String> getNoteNames() {
        return ((CatalinaSessionContext)this.session.get().getContext()).getNotes().keySet().iterator();
    }

    public void removeNote(String name) {
        ((CatalinaSessionContext)this.session.get().getContext()).getNotes().remove(name);
    }

    public void removeSessionListener(SessionListener listener) {
        ((CatalinaSessionContext)this.session.get().getContext()).getSessionListeners().remove(listener);
    }

    public void setNote(String name, Object value) {
        ((CatalinaSessionContext)this.session.get().getContext()).getNotes().put(name, value);
    }

    public void tellChangedSessionId(String newId, String oldId, boolean notifySessionListeners, boolean notifyContainerListeners) {
        try (BatchContext context = this.batch.resumeWithContext();){
            Session<CatalinaSessionContext> oldSession = this.session.get();
            Session newSession = this.manager.getSessionManager().createSession(newId);
            try {
                for (Map.Entry entry : oldSession.getAttributes().entrySet()) {
                    newSession.getAttributes().put((String)entry.getKey(), entry.getValue());
                }
                newSession.getMetaData().setTimeout(oldSession.getMetaData().getTimeout());
                newSession.getMetaData().setLastAccess(oldSession.getMetaData().getLastAccessStartTime(), oldSession.getMetaData().getLastAccessTime());
                ((CatalinaSessionContext)newSession.getContext()).setAuthType(((CatalinaSessionContext)oldSession.getContext()).getAuthType());
                ((CatalinaSessionContext)newSession.getContext()).setPrincipal(((CatalinaSessionContext)oldSession.getContext()).getPrincipal());
                this.session.set((Session<CatalinaSessionContext>)newSession);
                oldSession.invalidate();
            }
            catch (IllegalStateException e) {
                if (!oldSession.isValid()) {
                    oldSession.close();
                }
            }
        }
        context = this.manager.getContext();
        if (notifyContainerListeners) {
            context.fireContainerEvent("changeSessionId", (Object)new String[]{oldId, newId});
        }
        if (notifySessionListeners) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            Stream.of(context.getApplicationEventListeners()).filter(listener -> listener instanceof HttpSessionIdListener).map(listener -> (HttpSessionIdListener)listener).forEach(arg_0 -> DistributableSession.lambda$tellChangedSessionId$2(event, oldId, (Context)context, arg_0));
        }
    }

    public boolean isAttributeDistributable(String name, Object value) {
        return this.manager.getMarshallability().isMarshallable(value);
    }

    private static /* synthetic */ void lambda$tellChangedSessionId$2(HttpSessionEvent event, String oldId, Context context, HttpSessionIdListener listener) {
        try {
            listener.sessionIdChanged(event, oldId);
        }
        catch (Throwable e) {
            context.getLogger().warn((Object)e.getMessage(), e);
        }
    }
}

