/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.wildfly.clustering.web.cache.session.ImmutableFilteringHttpSession;
import org.wildfly.clustering.web.session.ImmutableSession;

public class CatalinaSessionDestroyAction
implements Consumer<ImmutableSession> {
    private final Context context;

    public CatalinaSessionDestroyAction(Context context) {
        this.context = context;
    }

    @Override
    public void accept(ImmutableSession session) {
        ImmutableFilteringHttpSession httpSession = new ImmutableFilteringHttpSession(session, this.context.getServletContext());
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpSession);
        Stream.of(this.context.getApplicationLifecycleListeners()).filter(HttpSessionListener.class::isInstance).map(HttpSessionListener.class::cast).forEach(listener -> {
            try {
                this.context.fireContainerEvent("beforeSessionDestroyed", listener);
                listener.sessionDestroyed(event);
            }
            catch (Throwable e) {
                this.context.getLogger().warn((Object)e.getMessage(), e);
            }
            finally {
                this.context.fireContainerEvent("afterSessionDestroyed", listener);
            }
        });
        for (Map.Entry entry : httpSession.getAttributes(HttpSessionBindingListener.class).entrySet()) {
            HttpSessionBindingListener listener2 = (HttpSessionBindingListener)entry.getValue();
            try {
                listener2.valueUnbound(new HttpSessionBindingEvent((HttpSession)httpSession, (String)entry.getKey(), (Object)listener2));
            }
            catch (Throwable e) {
                this.context.getLogger().warn((Object)e.getMessage(), e);
            }
        }
    }
}

