/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.io.IOException;
import java.time.Duration;
import java.util.OptionalLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.tomcat.catalina.CatalinaManager;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionDestroyAction;
import org.wildfly.clustering.tomcat.catalina.DistributableSession;
import org.wildfly.clustering.tomcat.catalina.LocalSessionContext;
import org.wildfly.clustering.web.cache.session.ImmutableFilteringHttpSession;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionManager;

public class DistributableManager<B extends Batch>
implements CatalinaManager<B> {
    private static final char ROUTE_DELIMITER = '.';
    private final SessionManager<LocalSessionContext, B> manager;
    private final Context context;
    private final Consumer<ImmutableSession> invalidateAction;
    private final Marshallability marshallability;
    private final String route;
    private final StampedLock lifecycleLock = new StampedLock();
    private OptionalLong lifecycleStamp = OptionalLong.empty();

    public DistributableManager(SessionManager<LocalSessionContext, B> manager, Context context, Marshallability marshallability) {
        this.manager = manager;
        this.marshallability = marshallability;
        this.context = context;
        this.route = ((Engine)context.getParent().getParent()).getJvmRoute();
        this.invalidateAction = new CatalinaSessionDestroyAction(context);
        this.manager.setDefaultMaxInactiveInterval(Duration.ofMinutes(context.getSessionTimeout()));
    }

    @Override
    public SessionManager<LocalSessionContext, B> getSessionManager() {
        return this.manager;
    }

    @Override
    public Marshallability getMarshallability() {
        return this.marshallability;
    }

    private static String parseSessionId(String requestedSesssionId) {
        int index = requestedSesssionId.indexOf(46);
        return index < 0 ? requestedSesssionId : requestedSesssionId.substring(0, index);
    }

    private Session getSession(org.wildfly.clustering.web.session.Session<LocalSessionContext> session, Runnable closeTask) {
        String id = session.getId();
        String internalId = this.route != null ? new StringBuilder(id.length() + this.route.length() + 1).append(id).append('.').append(this.route).toString() : id;
        return new DistributableSession<Batch>(this, session, internalId, this.manager.getBatcher().suspendBatch(), () -> this.invalidateAction.accept((ImmutableSession)session), closeTask);
    }

    public void start() throws LifecycleException {
        this.lifecycleStamp.ifPresent(stamp -> this.lifecycleLock.unlock(stamp));
        this.manager.setDefaultMaxInactiveInterval(Duration.ofMinutes(this.context.getSessionTimeout()));
        this.manager.start();
    }

    public void stop() throws LifecycleException {
        if (!this.lifecycleStamp.isPresent()) {
            try {
                this.lifecycleStamp = OptionalLong.of(this.lifecycleLock.writeLockInterruptibly());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.manager.stop();
        }
    }

    /*
     * Loose catch block
     */
    public Session createSession(String sessionId) {
        String id = sessionId != null ? DistributableManager.parseSessionId(sessionId) : (String)this.manager.createIdentifier();
        Runnable closeTask = this.getSessionCloseTask();
        boolean close = true;
        try {
            Batcher batcher = this.manager.getBatcher();
            Batch batch = batcher.createBatch();
            try {
                org.wildfly.clustering.web.session.Session session = this.manager.createSession(id);
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)new ImmutableFilteringHttpSession((ImmutableSession)session, this.context.getServletContext()));
                Stream.of(this.context.getApplicationLifecycleListeners()).filter(HttpSessionListener.class::isInstance).map(HttpSessionListener.class::cast).forEach(listener -> {
                    try {
                        this.context.fireContainerEvent("beforeSessionCreated", listener);
                        listener.sessionCreated(event);
                    }
                    catch (Throwable e) {
                        this.context.getLogger().warn((Object)e.getMessage(), e);
                    }
                    finally {
                        this.context.fireContainerEvent("afterSessionCreated", listener);
                    }
                });
                Session result = this.getSession((org.wildfly.clustering.web.session.Session<LocalSessionContext>)session, closeTask);
                close = false;
                Session session2 = result;
                return session2;
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
            finally {
                if (close) {
                    batch.close();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (close) {
                closeTask.run();
            }
        }
    }

    /*
     * Loose catch block
     */
    public Session findSession(String sessionId) throws IOException {
        String id = DistributableManager.parseSessionId(sessionId);
        Runnable closeTask = this.getSessionCloseTask();
        boolean close = true;
        try {
            Session session;
            Batcher batcher = this.manager.getBatcher();
            Batch batch = batcher.createBatch();
            try {
                org.wildfly.clustering.web.session.Session session2 = this.manager.findSession(id);
                if (session2 == null) {
                    Session session3 = null;
                    return session3;
                }
                Session result = this.getSession((org.wildfly.clustering.web.session.Session<LocalSessionContext>)session2, closeTask);
                close = false;
                session = result;
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
            finally {
                if (close) {
                    batch.close();
                }
            }
            return session;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (close) {
                closeTask.run();
            }
        }
    }

    private Runnable getSessionCloseTask() {
        long stamp = this.lifecycleLock.tryReadLock();
        if (stamp == 0L) {
            throw new IllegalStateException("Session manager was stopped");
        }
        return () -> this.lifecycleLock.unlock(stamp);
    }

    @Deprecated
    public void changeSessionId(Session session) {
        this.changeSessionId(session, (String)this.manager.createIdentifier());
    }

    public void changeSessionId(Session session, String id) {
        session.tellChangedSessionId(id, session.getId(), true, true);
    }

    public Context getContext() {
        return this.context;
    }

    public boolean willAttributeDistribute(String name, Object value) {
        return this.marshallability.isMarshallable(value);
    }

    public void setNotifyBindingListenerOnUnchangedValue(boolean notify) {
    }

    public void setNotifyAttributeListenerOnUnchangedValue(boolean notify) {
    }
}

