/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.infinispan.embedded;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.jgroups.ChannelListener;
import org.jgroups.EmptyMessage;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.fork.UnknownForkHandler;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.StackType;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;
import org.wildfly.clustering.tomcat.infinispan.embedded.ClassLoaderThreadFactory;

public class JChannelConfigurator
implements JGroupsChannelConfigurator {
    static final String DEFAULT_JGROUPS_RESOURCE = "default-configs/default-jgroups-udp.xml";
    static final ByteBuffer UNKNOWN_FORK_RESPONSE = ByteBuffer.allocate(0);
    private final String name;
    private final ProtocolStackConfigurator configurator;
    private final List<ChannelListener> listeners = new LinkedList<ChannelListener>();

    public JChannelConfigurator(TransportConfiguration transport, ClassLoader loader) throws IOException {
        this.name = transport.stack();
        this.configurator = JChannelConfigurator.getProtocolStackConfigurator(transport, loader);
    }

    private static ProtocolStackConfigurator getProtocolStackConfigurator(TransportConfiguration transport, ClassLoader loader) throws IOException {
        TypedProperties properties = transport.properties();
        if (properties.containsKey("channelConfigurator")) {
            return (JGroupsChannelConfigurator)properties.get("channelConfigurator");
        }
        if (properties.containsKey("configurationXml")) {
            String xml = properties.getProperty("configurationXml");
            try (ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));){
                XmlConfigurator xmlConfigurator = XmlConfigurator.getInstance((InputStream)input);
                return xmlConfigurator;
            }
        }
        String location = properties.getProperty("configurationFile", DEFAULT_JGROUPS_RESOURCE);
        URL resource = loader.getResource(location);
        if (resource == null) {
            throw new FileNotFoundException(location);
        }
        try (InputStream input = resource.openStream();){
            XmlConfigurator xmlConfigurator = XmlConfigurator.getInstance((InputStream)input);
            return xmlConfigurator;
        }
    }

    public String getProtocolStackString() {
        return this.configurator.getProtocolStackString();
    }

    public List<ProtocolConfiguration> getProtocolStack() {
        return this.configurator.getProtocolStack();
    }

    public String getName() {
        return this.name;
    }

    public JChannel createChannel(String name) throws Exception {
        final FORK fork = new FORK();
        fork.setUnknownForkHandler(new UnknownForkHandler(){
            private final short id = ClassConfigurator.getProtocolId(RequestCorrelator.class);

            public Object handleUnknownForkStack(Message message, String forkStackId) {
                return this.handle(message);
            }

            public Object handleUnknownForkChannel(Message message, String forkChannelId) {
                return this.handle(message);
            }

            private Object handle(Message message) {
                RequestCorrelator.Header header = (RequestCorrelator.Header)message.getHeader(this.id);
                if (header != null && header.type == 0 && header.rspExpected()) {
                    Message response = new EmptyMessage(message.src()).setFlag(message.getFlags(), false).clearFlag(new Message.Flag[]{Message.Flag.RSVP});
                    if (message.getDest() != null) {
                        response.src(message.getDest());
                    }
                    response.putHeader(FORK.ID, message.getHeader(FORK.ID));
                    response.putHeader(this.id, (Header)new RequestCorrelator.Header(1, header.req_id, header.corrId));
                    fork.getProtocolStack().getChannel().down(response);
                }
                return null;
            }
        });
        List<ProtocolConfiguration> configurations = this.getProtocolStack();
        ArrayList<Object> protocols = new ArrayList<Object>(configurations.size() + 1);
        Properties properties = System.getProperties();
        for (ProtocolConfiguration configuration : configurations) {
            String protocolName = configuration.getProtocolName();
            Object className = protocolName.startsWith("org.jgroups.protocols.") ? protocolName : "org.jgroups.protocols." + protocolName;
            try {
                Class<Protocol> protocolClass = Protocol.class.getClassLoader().loadClass((String)className).asSubclass(Protocol.class);
                Protocol protocol = protocolClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                StringPropertyReplacer.replaceProperties((Map)configuration.getProperties(), (Properties)properties);
                StackType type = Util.getIpStackType();
                Configurator.initializeAttrs((Protocol)protocol, (ProtocolConfiguration)configuration, (StackType)type);
                protocols.add(protocol);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        protocols.add(fork);
        TP transport = (TP)protocols.get(0);
        transport.setThreadFactory((ThreadFactory)new ClassLoaderThreadFactory((ThreadFactory)new DefaultThreadFactory("jgroups", false, true), JChannelConfigurator.class.getClassLoader()));
        JChannel channel = new JChannel(protocols);
        this.listeners.forEach(arg_0 -> ((JChannel)channel).addChannelListener(arg_0));
        return channel;
    }

    public void addChannelListener(ChannelListener listener) {
        this.listeners.add(listener);
    }

    public void setSocketFactory(SocketFactory socketFactory) {
    }

    public void setDataSource(DataSource dataSource) {
    }
}

