/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.io.Serializable;
import org.wildfly.clustering.marshalling.jdk.ClassResolver;
import org.wildfly.clustering.marshalling.jdk.ObjectInputStream;
import org.wildfly.clustering.marshalling.jdk.ObjectOutputStream;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;

public class JavaByteBufferMarshaller
implements ByteBufferMarshaller {
    private final ClassResolver resolver;

    public JavaByteBufferMarshaller(ClassResolver resolver) {
        this.resolver = resolver;
    }

    public boolean isMarshallable(Object object) {
        return object == null || object instanceof Serializable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readFrom(InputStream in) throws IOException {
        try (ObjectInputStream input = new ObjectInputStream(in, this.resolver);){
            Object object = input.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            InvalidClassException exception = new InvalidClassException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    public void writeTo(OutputStream out, Object object) throws IOException {
        try (ObjectOutputStream output = new ObjectOutputStream(out, this.resolver);){
            output.writeObject(object);
        }
    }
}

