/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat;

import java.util.NoSuchElementException;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jdk.ClassLoaderResolver;
import org.wildfly.clustering.marshalling.jdk.JavaByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.tomcat.JBossMarshallingVersion;

public enum SessionMarshallerFactory implements Function<ClassLoader, ByteBufferMarshaller>
{
    JAVA{

        @Override
        public ByteBufferMarshaller apply(ClassLoader loader) {
            return new JavaByteBufferMarshaller(new ClassLoaderResolver(loader));
        }
    }
    ,
    JBOSS{

        @Override
        public ByteBufferMarshaller apply(ClassLoader loader) {
            return new JBossByteBufferMarshaller((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(JBossMarshallingVersion.class, (Enum)JBossMarshallingVersion.CURRENT, (Object)loader), loader);
        }
    }
    ,
    PROTOSTREAM{

        @Override
        public ByteBufferMarshaller apply(ClassLoader loader) {
            SerializationContextBuilder builder = new SerializationContextBuilder();
            try {
                builder.register(new ClassLoader[]{loader});
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return new ProtoStreamByteBufferMarshaller(builder.build());
        }
    };

}

