/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.servlet;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.wildfly.clustering.tomcat.servlet.MutableInteger;
import org.wildfly.clustering.tomcat.servlet.ServletService;
import org.wildfly.clustering.tomcat.servlet.ServletSession;

public interface ServletHandler<REQUEST, RESPONSE> {
    public static final String SERVLET_NAME = "session";
    public static final String SERVLET_PATH = "/session";
    public static final String VALUE = "value";
    public static final String SESSION_ID = "session-id";

    public static URI createURI(URL baseURL) throws URISyntaxException {
        return baseURL.toURI().resolve(SERVLET_NAME);
    }

    public void doHead(REQUEST var1, RESPONSE var2) throws IOException;

    public void doGet(REQUEST var1, RESPONSE var2) throws IOException;

    public void doDelete(REQUEST var1, RESPONSE var2) throws IOException;

    default public void doHead(ServletService service) throws IOException {
        ServletSession session = service.getSession(false);
        if (session != null) {
            service.setHeader(SESSION_ID, session.getId());
        }
    }

    default public void doGet(ServletService service) throws IOException {
        ServletSession session = service.getSession();
        service.setHeader(SESSION_ID, session.getId());
        MutableInteger value = (MutableInteger)session.getAttribute(VALUE);
        if (value == null) {
            value = new MutableInteger(0);
            session.setAttribute(VALUE, value);
        } else {
            value.accept(value.getAsInt() + 1);
        }
        service.setHeader(VALUE, value.getAsInt());
    }

    default public void doDelete(ServletService service) throws IOException {
        ServletSession session = service.getSession(false);
        if (session != null) {
            service.setHeader(SESSION_ID, session.getId());
            session.invalidate();
        }
    }
}

