/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat;

import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.tomcat.servlet.MutableIntegerExternalizer;
import org.wildfly.clustering.tomcat.servlet.ServletHandler;
import org.wildfly.clustering.tomcat.servlet.TestSerializationContextInitializer;

public abstract class AbstractSmokeITCase {
    static final String INFINISPAN_SERVER_HOME = System.getProperty("infinispan.server.home");
    static final String INFINISPAN_DRIVER_USERNAME = "testsuite-driver-user";
    static final String INFINISPAN_DRIVER_PASSWORD = "testsuite-driver-password";
    @ClassRule
    public static final TestRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)(INFINISPAN_SERVER_HOME + "/server/conf/infinispan.xml")).property("org.infinispan.test.server.dir", INFINISPAN_SERVER_HOME)).property("infinispan.client.rest.auth_username", "testsuite-driver-user")).property("infinispan.client.rest.auth_password", "testsuite-driver-password")).runMode(ServerRunMode.FORKED)).numServers(1)).build();

    public static Archive<?> deployment(Class<? extends AbstractSmokeITCase> testClass, Class<? extends ServletHandler<?, ?>> servletClass) {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(testClass.getSimpleName() + ".war"))).addPackage(ServletHandler.class.getPackage())).addPackage(servletClass.getPackage())).addAsServiceProvider(Externalizer.class, new Class[]{MutableIntegerExternalizer.class})).addAsServiceProvider(SerializationContextInitializer.class.getName(), new String[]{TestSerializationContextInitializer.class.getName() + "Impl"});
    }

    protected void test(URL baseURL1, URL baseURL2) throws Exception {
        URI uri1 = ServletHandler.createURI(baseURL1);
        URI uri2 = ServletHandler.createURI(baseURL2);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            String sessionId = null;
            int value = 0;
            for (int i = 0; i < 4; ++i) {
                for (URI uri : Arrays.asList(uri1, uri2)) {
                    for (int j = 0; j < 4; ++j) {
                        try (CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(uri));){
                            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                            Assert.assertEquals((Object)String.valueOf(value++), (Object)response.getFirstHeader("value").getValue());
                            String requestSessionId = response.getFirstHeader("session-id").getValue();
                            if (sessionId == null) {
                                sessionId = requestSessionId;
                                continue;
                            }
                            Assert.assertEquals((Object)sessionId, (Object)requestSessionId);
                            continue;
                        }
                    }
                    Thread.sleep(500L);
                }
            }
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpDelete(uri1));){
                Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                Assert.assertEquals(sessionId, (Object)response.getFirstHeader("session-id").getValue());
            }
            response = client.execute((HttpUriRequest)new HttpHead(uri2));
            try {
                Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                Assert.assertFalse((boolean)response.containsHeader("session-id"));
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
    }
}

