/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.io.Serializable;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jdk.ObjectInputStream;
import org.wildfly.clustering.marshalling.jdk.ObjectOutputStream;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;

public class JavaByteBufferMarshaller
implements ByteBufferMarshaller {
    private final Externalizer<ClassLoader> externalizer;

    public JavaByteBufferMarshaller(Externalizer<ClassLoader> externalizer) {
        this.externalizer = externalizer;
    }

    public boolean isMarshallable(Object object) {
        return object == null || object instanceof Serializable;
    }

    public Object readFrom(InputStream in) throws IOException {
        Object object;
        ObjectInputStream input = new ObjectInputStream(in, this.externalizer);
        try {
            object = input.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                InvalidClassException exception = new InvalidClassException(e.getMessage());
                exception.initCause(e);
                throw exception;
            }
        }
        input.close();
        return object;
    }

    public void writeTo(OutputStream out, Object object) throws IOException {
        try (ObjectOutputStream output = new ObjectOutputStream(out, this.externalizer);){
            output.writeObject(object);
        }
    }
}

