/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat;

import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.tomcat.servlet.MutableIntegerExternalizer;
import org.wildfly.clustering.tomcat.servlet.ServletHandler;
import org.wildfly.clustering.tomcat.servlet.TestSerializationContextInitializer;

public abstract class AbstractSmokeITCase {
    static final String INFINISPAN_SERVER_HOME = System.getProperty("infinispan.server.home");
    static final String INFINISPAN_SERVER_PROFILE = System.getProperty("infinispan.server.profile");
    static final String INFINISPAN_DRIVER_USERNAME = "testsuite-driver-user";
    static final String INFINISPAN_DRIVER_PASSWORD = "testsuite-driver-password";
    @ClassRule
    public static final TestRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)INFINISPAN_SERVER_PROFILE).property("org.infinispan.test.server.dir", INFINISPAN_SERVER_HOME)).property("infinispan.client.rest.auth_username", "testsuite-driver-user")).property("infinispan.client.rest.auth_password", "testsuite-driver-password")).runMode(ServerRunMode.FORKED)).numServers(1)).build();

    public static Archive<?> deployment(Class<? extends AbstractSmokeITCase> testClass, Class<? extends ServletHandler<?, ?>> servletClass) {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(testClass.getSimpleName() + ".war"))).addPackage(ServletHandler.class.getPackage())).addPackage(servletClass.getPackage())).addAsServiceProvider(Externalizer.class, new Class[]{MutableIntegerExternalizer.class})).addAsServiceProvider(SerializationContextInitializer.class.getName(), new String[]{TestSerializationContextInitializer.class.getName() + "Impl"});
    }

    protected void test(URL baseURL1, URL baseURL2) throws Exception {
        URI uri1 = ServletHandler.createURI(baseURL1);
        URI uri2 = ServletHandler.createURI(baseURL2);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            AtomicReference<String> sessionId = new AtomicReference<String>();
            AtomicInteger value = new AtomicInteger(0);
            for (int i = 0; i < 4; ++i) {
                for (URI uri : Arrays.asList(uri1, uri2)) {
                    for (int j = 0; j < 4; ++j) {
                        Map.Entry result = (Map.Entry)client.execute((ClassicHttpRequest)new HttpGet(uri), response -> {
                            Assert.assertEquals((long)200L, (long)response.getCode());
                            return Map.entry(response.getFirstHeader("session-id").getValue(), response.getFirstHeader("value").getValue());
                        });
                        Assert.assertEquals((Object)String.valueOf(value.getAndIncrement()), result.getValue());
                        String requestSessionId = (String)result.getKey();
                        if (sessionId.compareAndSet(null, requestSessionId)) continue;
                        Assert.assertEquals(sessionId.get(), (Object)requestSessionId);
                    }
                    Thread.sleep(500L);
                }
            }
            String requestSessionId = (String)client.execute((ClassicHttpRequest)new HttpDelete(uri1), response -> {
                Assert.assertEquals((long)200L, (long)response.getCode());
                return response.getFirstHeader("session-id").getValue();
            });
            Assert.assertEquals(sessionId.get(), (Object)requestSessionId);
            requestSessionId = (String)client.execute((ClassicHttpRequest)new HttpHead(uri2), response -> {
                Assert.assertEquals((long)200L, (long)response.getCode());
                return Optional.ofNullable(response.getFirstHeader("session-id")).map(NameValuePair::getValue).orElse(null);
            });
            Assert.assertNull((Object)requestSessionId);
        }
    }
}

