/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.Consumer;

public class ContextClassLoaderAction
implements Consumer<Runnable> {
    private final WeakReference<ClassLoader> loader;

    public ContextClassLoaderAction(ClassLoader loader) {
        this.loader = new WeakReference<ClassLoader>(loader);
    }

    @Override
    public void accept(Runnable task) {
        try (ClassLoaderContext context = ContextClassLoaderAction.getClassLoaderContext((ClassLoader)this.loader.get());){
            task.run();
        }
    }

    private static ClassLoaderContext getClassLoaderContext(ClassLoader loader) {
        if (loader == null) {
            return () -> {};
        }
        PrivilegedAction<ClassLoader> action = () -> Thread.currentThread().getContextClassLoader();
        ClassLoader existingLoader = AccessController.doPrivileged(action);
        ContextClassLoaderAction.setContextClassLoader(loader);
        return () -> ContextClassLoaderAction.setContextClassLoader(existingLoader);
    }

    private static void setContextClassLoader(ClassLoader loader) {
        PrivilegedAction<Void> action = () -> {
            Thread.currentThread().setContextClassLoader(loader);
            return null;
        };
        AccessController.doPrivileged(action);
    }

    private static interface ClassLoaderContext
    extends AutoCloseable {
        @Override
        public void close();
    }
}

