/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat;

import java.io.ObjectInputFilter;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.java.JavaByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.tomcat.JBossMarshallingVersion;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SessionMarshallerFactory implements BiFunction<UnaryOperator<String>, ClassLoader, ByteBufferMarshaller>
{
    JAVA{

        @Override
        public ByteBufferMarshaller apply(UnaryOperator<String> properties, ClassLoader loader) {
            ObjectInputFilter filter = Optional.ofNullable((String)properties.apply("jdk.serialFilter")).map(ObjectInputFilter.Config::createFilter).orElse(null);
            return new JavaByteBufferMarshaller(loader, filter);
        }
    }
    ,
    JBOSS{

        @Override
        public ByteBufferMarshaller apply(UnaryOperator<String> properties, ClassLoader loader) {
            return new JBossByteBufferMarshaller(MarshallingConfigurationRepository.from((Enum)JBossMarshallingVersion.CURRENT, (Object)loader), loader);
        }
    }
    ,
    PROTOSTREAM{

        @Override
        public ByteBufferMarshaller apply(UnaryOperator<String> properties, ClassLoader loader) {
            return new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader)).build());
        }
    };

}

