package org.wildfly.swarm.config;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.subsystem.server.Server;
import org.wildfly.swarm.config.messaging.subsystem.jmsBridge.JmsBridge;
/**
 * The messaging-activemq subsystem.
 */
@Address("/subsystem=messaging-activemq")
@Implicit
public class MessagingMessagingActivemq<T extends MessagingMessagingActivemq> {

	private String key;
	private MessagingMessagingActivemqResources subresources = new MessagingMessagingActivemqResources();

	public MessagingMessagingActivemq() {
		this.key = "messaging-activemq";
	}

	public String getKey() {
		return this.key;
	}

	public MessagingMessagingActivemqResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Server objects to this subresource
	 * @return this
	 * @param value List of Server objects.
	 */
	@SuppressWarnings("unchecked")
	public T servers(List<Server> value) {
		this.subresources.servers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Server object to the list of subresources
	 * @param value The Server to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(Server value) {
		this.subresources.servers.add(value);
		return (T) this;
	}

	/**
	 * Add all JmsBridge objects to this subresource
	 * @return this
	 * @param value List of JmsBridge objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridges(List<JmsBridge> value) {
		this.subresources.jmsBridges.addAll(value);
		return (T) this;
	}

	/**
	 * Add the JmsBridge object to the list of subresources
	 * @param value The JmsBridge to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsBridge(JmsBridge value) {
		this.subresources.jmsBridges.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for MessagingMessagingActivemq
	 */
	public class MessagingMessagingActivemqResources {
		/**
		 * An ActiveMQ server instance.
		 */
		private List<Server> servers = new java.util.ArrayList<>();
		/**
		 * A JMS bridge instance.
		 */
		private List<JmsBridge> jmsBridges = new java.util.ArrayList<>();

		/**
		 * Get the list of Server resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Server> servers() {
			return this.servers;
		}

		/**
		 * Get the list of JmsBridge resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JmsBridge> jmsBridges() {
			return this.jmsBridges;
		}
	}
}