package org.wildfly.swarm.config;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.remoting.subsystem.httpConnector.HttpConnector;
import org.wildfly.swarm.config.remoting.subsystem.connector.Connector;
import org.wildfly.swarm.config.remoting.subsystem.outboundConnection.OutboundConnection;
import org.wildfly.swarm.config.remoting.subsystem.localOutboundConnection.LocalOutboundConnection;
import org.wildfly.swarm.config.remoting.subsystem.remoteOutboundConnection.RemoteOutboundConnection;
import org.wildfly.swarm.config.remoting.subsystem.ConfigurationEndpoint;
/**
 * The configuration of the Remoting subsystem.
 */
@Address("/subsystem=remoting")
@Implicit
public class Remoting<T extends Remoting> {

	private String key;
	private RemotingResources subresources = new RemotingResources();
	private ConfigurationEndpoint configurationEndpoint;

	public Remoting() {
		this.key = "remoting";
	}

	public String getKey() {
		return this.key;
	}

	public RemotingResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all HttpConnector objects to this subresource
	 * @return this
	 * @param value List of HttpConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpConnectors(List<HttpConnector> value) {
		this.subresources.httpConnectors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the HttpConnector object to the list of subresources
	 * @param value The HttpConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HttpConnector value) {
		this.subresources.httpConnectors.add(value);
		return (T) this;
	}

	/**
	 * Add all Connector objects to this subresource
	 * @return this
	 * @param value List of Connector objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(List<Connector> value) {
		this.subresources.connectors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Connector object to the list of subresources
	 * @param value The Connector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(Connector value) {
		this.subresources.connectors.add(value);
		return (T) this;
	}

	/**
	 * Add all OutboundConnection objects to this subresource
	 * @return this
	 * @param value List of OutboundConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnections(List<OutboundConnection> value) {
		this.subresources.outboundConnections.addAll(value);
		return (T) this;
	}

	/**
	 * Add the OutboundConnection object to the list of subresources
	 * @param value The OutboundConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnection(OutboundConnection value) {
		this.subresources.outboundConnections.add(value);
		return (T) this;
	}

	/**
	 * Add all LocalOutboundConnection objects to this subresource
	 * @return this
	 * @param value List of LocalOutboundConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnections(List<LocalOutboundConnection> value) {
		this.subresources.localOutboundConnections.addAll(value);
		return (T) this;
	}

	/**
	 * Add the LocalOutboundConnection object to the list of subresources
	 * @param value The LocalOutboundConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localOutboundConnection(LocalOutboundConnection value) {
		this.subresources.localOutboundConnections.add(value);
		return (T) this;
	}

	/**
	 * Add all RemoteOutboundConnection objects to this subresource
	 * @return this
	 * @param value List of RemoteOutboundConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnections(List<RemoteOutboundConnection> value) {
		this.subresources.remoteOutboundConnections.addAll(value);
		return (T) this;
	}

	/**
	 * Add the RemoteOutboundConnection object to the list of subresources
	 * @param value The RemoteOutboundConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteOutboundConnection(RemoteOutboundConnection value) {
		this.subresources.remoteOutboundConnections.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Remoting
	 */
	public class RemotingResources {
		/**
		 * The configuration of a HTTP Upgrade based Remoting connector.
		 */
		private List<HttpConnector> httpConnectors = new java.util.ArrayList<>();
		/**
		 * The configuration of a Remoting connector.
		 */
		private List<Connector> connectors = new java.util.ArrayList<>();
		/**
		 * Remoting outbound connection.
		 */
		private List<OutboundConnection> outboundConnections = new java.util.ArrayList<>();
		/**
		 * Remoting outbound connection with an implicit local:// URI scheme.
		 */
		private List<LocalOutboundConnection> localOutboundConnections = new java.util.ArrayList<>();
		/**
		 * Remoting outbound connection with an implicit remote:// URI scheme.
		 */
		private List<RemoteOutboundConnection> remoteOutboundConnections = new java.util.ArrayList<>();

		/**
		 * Get the list of HttpConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpConnector> httpConnectors() {
			return this.httpConnectors;
		}

		/**
		 * Get the list of Connector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Connector> connectors() {
			return this.connectors;
		}

		/**
		 * Get the list of OutboundConnection resources
		 * @return the list of resources
		 */
		@Subresource
		public List<OutboundConnection> outboundConnections() {
			return this.outboundConnections;
		}

		/**
		 * Get the list of LocalOutboundConnection resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LocalOutboundConnection> localOutboundConnections() {
			return this.localOutboundConnections;
		}

		/**
		 * Get the list of RemoteOutboundConnection resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteOutboundConnection> remoteOutboundConnections() {
			return this.remoteOutboundConnections;
		}
	}

	/**
	 * Endpoint configuration
	 */
	@Subresource
	public ConfigurationEndpoint configurationEndpoint() {
		return this.configurationEndpoint;
	}

	/**
	 * Endpoint configuration
	 */
	@SuppressWarnings("unchecked")
	public T configurationEndpoint(ConfigurationEndpoint value) {
		this.configurationEndpoint = value;
		return (T) this;
	}
}