package org.wildfly.swarm.config.ejb3.subsystem.mdbDeliveryGroup;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Delivery group to manage delivery for mdbs
 */
@Address("/subsystem=ejb3/mdb-delivery-group=*")
public class MdbDeliveryGroup<T extends MdbDeliveryGroup> {

	private String key;
	private Boolean active;

	public MdbDeliveryGroup(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Indicates if delivery for all MDBs belonging to this group is active
	 */
	@ModelNodeBinding(detypedName = "active")
	public Boolean active() {
		return this.active;
	}

	/**
	 * Indicates if delivery for all MDBs belonging to this group is active
	 */
	@SuppressWarnings("unchecked")
	public T active(Boolean value) {
		this.active = value;
		return (T) this;
	}
}