package org.wildfly.swarm.config.ejb3.subsystem.service.databaseDataStore;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * An database based store for persistent EJB timers.
 */
@Address("/subsystem=ejb3/service=timer-service/database-data-store=*")
public class DatabaseDataStore<T extends DatabaseDataStore> {

	private String key;
	private Boolean allowExecution;
	private String database;
	private String datasourceJndiName;
	private String partition;
	private Integer refreshInterval;

	public DatabaseDataStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If this node is allowed to execute timers. If this is false then the timers will be added to the database, and another node may execute them. Note that depending on your refresh interval if you add timers with a very short delay they will not be executed until another node refreshes.
	 */
	@ModelNodeBinding(detypedName = "allow-execution")
	public Boolean allowExecution() {
		return this.allowExecution;
	}

	/**
	 * If this node is allowed to execute timers. If this is false then the timers will be added to the database, and another node may execute them. Note that depending on your refresh interval if you add timers with a very short delay they will not be executed until another node refreshes.
	 */
	@SuppressWarnings("unchecked")
	public T allowExecution(Boolean value) {
		this.allowExecution = value;
		return (T) this;
	}

	/**
	 * The type of database that is in use. SQL can be customised per database type.
	 */
	@ModelNodeBinding(detypedName = "database")
	public String database() {
		return this.database;
	}

	/**
	 * The type of database that is in use. SQL can be customised per database type.
	 */
	@SuppressWarnings("unchecked")
	public T database(String value) {
		this.database = value;
		return (T) this;
	}

	/**
	 * The datasource that is used to persist the timers
	 */
	@ModelNodeBinding(detypedName = "datasource-jndi-name")
	public String datasourceJndiName() {
		return this.datasourceJndiName;
	}

	/**
	 * The datasource that is used to persist the timers
	 */
	@SuppressWarnings("unchecked")
	public T datasourceJndiName(String value) {
		this.datasourceJndiName = value;
		return (T) this;
	}

	/**
	 * The partition name. This should be set to a different value for every node that is sharing a database to prevent the same timer being loaded by multiple noded.
	 */
	@ModelNodeBinding(detypedName = "partition")
	public String partition() {
		return this.partition;
	}

	/**
	 * The partition name. This should be set to a different value for every node that is sharing a database to prevent the same timer being loaded by multiple noded.
	 */
	@SuppressWarnings("unchecked")
	public T partition(String value) {
		this.partition = value;
		return (T) this;
	}

	/**
	 * Interval between refreshing the current timer set against the underlying database. A low value means timers get picked up more quickly, but increase load on the database.
	 */
	@ModelNodeBinding(detypedName = "refresh-interval")
	public Integer refreshInterval() {
		return this.refreshInterval;
	}

	/**
	 * Interval between refreshing the current timer set against the underlying database. A low value means timers get picked up more quickly, but increase load on the database.
	 */
	@SuppressWarnings("unchecked")
	public T refreshInterval(Integer value) {
		this.refreshInterval = value;
		return (T) this;
	}
}