package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.invalidationCache.InvalidationCache;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache.LocalCache;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.replicatedCache.ReplicatedCache;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache.DistributedCache;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.TransportJgroups;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.ThreadPoolRemoteCommand;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.ThreadPoolAsyncOperations;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.ThreadPoolExpiration;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.TransportNone;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.ThreadPoolTransport;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.ThreadPoolPersistence;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.ThreadPoolListener;
import org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.ThreadPoolStateTransfer;
/**
 * The configuration of an infinispan cache container
 */
@Address("/subsystem=infinispan/cache-container=*")
public class CacheContainer<T extends CacheContainer> {

	private String key;
	private List<String> aliases;
	private String cacheManagerStatus;
	private String clusterName;
	private String coordinatorAddress;
	private String defaultCache;
	private Boolean isCoordinator;
	private String jndiName;
	private String localAddress;
	private String module;
	private Boolean statisticsEnabled;
	private CacheContainerResources subresources = new CacheContainerResources();
	private TransportJgroups transportJgroups;
	private ThreadPoolRemoteCommand threadPoolRemoteCommand;
	private ThreadPoolAsyncOperations threadPoolAsyncOperations;
	private ThreadPoolExpiration threadPoolExpiration;
	private TransportNone transportNone;
	private ThreadPoolTransport threadPoolTransport;
	private ThreadPoolPersistence threadPoolPersistence;
	private ThreadPoolListener threadPoolListener;
	private ThreadPoolStateTransfer threadPoolStateTransfer;

	public CacheContainer(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The list of aliases for this cache container
	 */
	@ModelNodeBinding(detypedName = "aliases")
	public List<String> aliases() {
		return this.aliases;
	}

	/**
	 * The list of aliases for this cache container
	 */
	@SuppressWarnings("unchecked")
	public T aliases(List<String> value) {
		this.aliases = value;
		return (T) this;
	}

	/**
	 * The status of the cache manager component. May return null if the cache manager is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-manager-status")
	public String cacheManagerStatus() {
		return this.cacheManagerStatus;
	}

	/**
	 * The status of the cache manager component. May return null if the cache manager is not started.
	 */
	@SuppressWarnings("unchecked")
	public T cacheManagerStatus(String value) {
		this.cacheManagerStatus = value;
		return (T) this;
	}

	/**
	 * The name of the cluster this node belongs to. May return null if the cache manager is not started.
	 */
	@ModelNodeBinding(detypedName = "cluster-name")
	public String clusterName() {
		return this.clusterName;
	}

	/**
	 * The name of the cluster this node belongs to. May return null if the cache manager is not started.
	 */
	@SuppressWarnings("unchecked")
	public T clusterName(String value) {
		this.clusterName = value;
		return (T) this;
	}

	/**
	 * The logical address of the cluster's coordinator. May return null if the cache manager is not started.
	 */
	@ModelNodeBinding(detypedName = "coordinator-address")
	public String coordinatorAddress() {
		return this.coordinatorAddress;
	}

	/**
	 * The logical address of the cluster's coordinator. May return null if the cache manager is not started.
	 */
	@SuppressWarnings("unchecked")
	public T coordinatorAddress(String value) {
		this.coordinatorAddress = value;
		return (T) this;
	}

	/**
	 * The default infinispan cache
	 */
	@ModelNodeBinding(detypedName = "default-cache")
	public String defaultCache() {
		return this.defaultCache;
	}

	/**
	 * The default infinispan cache
	 */
	@SuppressWarnings("unchecked")
	public T defaultCache(String value) {
		this.defaultCache = value;
		return (T) this;
	}

	/**
	 * Set to true if this node is the cluster's coordinator. May return null if the cache manager is not started.
	 */
	@ModelNodeBinding(detypedName = "is-coordinator")
	public Boolean isCoordinator() {
		return this.isCoordinator;
	}

	/**
	 * Set to true if this node is the cluster's coordinator. May return null if the cache manager is not started.
	 */
	@SuppressWarnings("unchecked")
	public T isCoordinator(Boolean value) {
		this.isCoordinator = value;
		return (T) this;
	}

	/**
	 * The jndi name to which to bind this cache container
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The jndi name to which to bind this cache container
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		this.jndiName = value;
		return (T) this;
	}

	/**
	 * The local address of the node. May return null if the cache manager is not started.
	 */
	@ModelNodeBinding(detypedName = "local-address")
	public String localAddress() {
		return this.localAddress;
	}

	/**
	 * The local address of the node. May return null if the cache manager is not started.
	 */
	@SuppressWarnings("unchecked")
	public T localAddress(String value) {
		this.localAddress = value;
		return (T) this;
	}

	/**
	 * The module whose class loader should be used when building this cache container's configuration.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module whose class loader should be used when building this cache container's configuration.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		this.module = value;
		return (T) this;
	}

	/**
	 * If enabled, statistics will be collected for this cache container
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If enabled, statistics will be collected for this cache container
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (T) this;
	}

	public CacheContainerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all InvalidationCache objects to this subresource
	 * @return this
	 * @param value List of InvalidationCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T invalidationCaches(List<InvalidationCache> value) {
		this.subresources.invalidationCaches.addAll(value);
		return (T) this;
	}

	/**
	 * Add the InvalidationCache object to the list of subresources
	 * @param value The InvalidationCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T invalidationCache(InvalidationCache value) {
		this.subresources.invalidationCaches.add(value);
		return (T) this;
	}

	/**
	 * Add all LocalCache objects to this subresource
	 * @return this
	 * @param value List of LocalCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T localCaches(List<LocalCache> value) {
		this.subresources.localCaches.addAll(value);
		return (T) this;
	}

	/**
	 * Add the LocalCache object to the list of subresources
	 * @param value The LocalCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localCache(LocalCache value) {
		this.subresources.localCaches.add(value);
		return (T) this;
	}

	/**
	 * Add all ReplicatedCache objects to this subresource
	 * @return this
	 * @param value List of ReplicatedCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T replicatedCaches(List<ReplicatedCache> value) {
		this.subresources.replicatedCaches.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ReplicatedCache object to the list of subresources
	 * @param value The ReplicatedCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T replicatedCache(ReplicatedCache value) {
		this.subresources.replicatedCaches.add(value);
		return (T) this;
	}

	/**
	 * Add all DistributedCache objects to this subresource
	 * @return this
	 * @param value List of DistributedCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T distributedCaches(List<DistributedCache> value) {
		this.subresources.distributedCaches.addAll(value);
		return (T) this;
	}

	/**
	 * Add the DistributedCache object to the list of subresources
	 * @param value The DistributedCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedCache(DistributedCache value) {
		this.subresources.distributedCaches.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for CacheContainer
	 */
	public class CacheContainerResources {
		/**
		 * An invalidation cache
		 */
		private List<InvalidationCache> invalidationCaches = new java.util.ArrayList<>();
		/**
		 * A local cache configuration
		 */
		private List<LocalCache> localCaches = new java.util.ArrayList<>();
		/**
		 * A replicated cache configuration
		 */
		private List<ReplicatedCache> replicatedCaches = new java.util.ArrayList<>();
		/**
		 * A distributed cache configuration.
		 */
		private List<DistributedCache> distributedCaches = new java.util.ArrayList<>();

		/**
		 * Get the list of InvalidationCache resources
		 * @return the list of resources
		 */
		@Subresource
		public List<InvalidationCache> invalidationCaches() {
			return this.invalidationCaches;
		}

		/**
		 * Get the list of LocalCache resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LocalCache> localCaches() {
			return this.localCaches;
		}

		/**
		 * Get the list of ReplicatedCache resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ReplicatedCache> replicatedCaches() {
			return this.replicatedCaches;
		}

		/**
		 * Get the list of DistributedCache resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DistributedCache> distributedCaches() {
			return this.distributedCaches;
		}
	}

	/**
	 * The description of the transport used by this cache container
	 */
	@Subresource
	public TransportJgroups transportJgroups() {
		return this.transportJgroups;
	}

	/**
	 * The description of the transport used by this cache container
	 */
	@SuppressWarnings("unchecked")
	public T transportJgroups(TransportJgroups value) {
		this.transportJgroups = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used to execute remote commands.
	 */
	@Subresource
	public ThreadPoolRemoteCommand threadPoolRemoteCommand() {
		return this.threadPoolRemoteCommand;
	}

	/**
	 * Defines a thread pool used to execute remote commands.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolRemoteCommand(ThreadPoolRemoteCommand value) {
		this.threadPoolRemoteCommand = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@Subresource
	public ThreadPoolAsyncOperations threadPoolAsyncOperations() {
		return this.threadPoolAsyncOperations;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolAsyncOperations(ThreadPoolAsyncOperations value) {
		this.threadPoolAsyncOperations = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for evictions.
	 */
	@Subresource
	public ThreadPoolExpiration threadPoolExpiration() {
		return this.threadPoolExpiration;
	}

	/**
	 * Defines a thread pool used for for evictions.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolExpiration(ThreadPoolExpiration value) {
		this.threadPoolExpiration = value;
		return (T) this;
	}

	/**
	 * A local-only transport used by this cache-container
	 */
	@Subresource
	public TransportNone transportNone() {
		return this.transportNone;
	}

	/**
	 * A local-only transport used by this cache-container
	 */
	@SuppressWarnings("unchecked")
	public T transportNone(TransportNone value) {
		this.transportNone = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous transport communication.
	 */
	@Subresource
	public ThreadPoolTransport threadPoolTransport() {
		return this.threadPoolTransport;
	}

	/**
	 * Defines a thread pool used for asynchronous transport communication.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolTransport(ThreadPoolTransport value) {
		this.threadPoolTransport = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for interacting with the persistent store.
	 */
	@Subresource
	public ThreadPoolPersistence threadPoolPersistence() {
		return this.threadPoolPersistence;
	}

	/**
	 * Defines a thread pool used for interacting with the persistent store.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolPersistence(ThreadPoolPersistence value) {
		this.threadPoolPersistence = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous cache listener notifications.
	 */
	@Subresource
	public ThreadPoolListener threadPoolListener() {
		return this.threadPoolListener;
	}

	/**
	 * Defines a thread pool used for asynchronous cache listener notifications.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolListener(ThreadPoolListener value) {
		this.threadPoolListener = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for state transfer.
	 */
	@Subresource
	public ThreadPoolStateTransfer threadPoolStateTransfer() {
		return this.threadPoolStateTransfer;
	}

	/**
	 * Defines a thread pool used for for state transfer.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolStateTransfer(ThreadPoolStateTransfer value) {
		this.threadPoolStateTransfer = value;
		return (T) this;
	}
}