package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Defines a thread pool used for for evictions.
 */
@Address("/subsystem=infinispan/cache-container=*/thread-pool=expiration")
@Implicit
public class ThreadPoolExpiration<T extends ThreadPoolExpiration> {

	private String key;
	private Long keepaliveTime;
	private Integer maxThreads;

	public ThreadPoolExpiration() {
		this.key = "expiration";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Long keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@SuppressWarnings("unchecked")
	public T keepaliveTime(Long value) {
		this.keepaliveTime = value;
		return (T) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public T maxThreads(Integer value) {
		this.maxThreads = value;
		return (T) this;
	}
}