package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The description of the transport used by this cache container
 */
@Address("/subsystem=infinispan/cache-container=*/transport=jgroups")
@Implicit
public class TransportJgroups<T extends TransportJgroups> {

	private String key;
	private String channel;
	private Long lockTimeout;

	public TransportJgroups() {
		this.key = "jgroups";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The channel of this cache container's transport.
	 */
	@ModelNodeBinding(detypedName = "channel")
	public String channel() {
		return this.channel;
	}

	/**
	 * The channel of this cache container's transport.
	 */
	@SuppressWarnings("unchecked")
	public T channel(String value) {
		this.channel = value;
		return (T) this;
	}

	/**
	 * The timeout for locks for the transport
	 */
	@ModelNodeBinding(detypedName = "lock-timeout")
	public Long lockTimeout() {
		return this.lockTimeout;
	}

	/**
	 * The timeout for locks for the transport
	 */
	@SuppressWarnings("unchecked")
	public T lockTimeout(Long value) {
		this.lockTimeout = value;
		return (T) this;
	}
}