package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A cache for which this cache acts as a backup (for use with cross site replication).
 */
@Address("/subsystem=infinispan/cache-container=*/distributed-cache=*/component=backup-for")
@Implicit
public class ComponentBackupFor<T extends ComponentBackupFor> {

	private String key;
	private String remoteCache;
	private String remoteSite;

	public ComponentBackupFor() {
		this.key = "backup-for";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the remote cache for which this cache acts as a backup.
	 */
	@ModelNodeBinding(detypedName = "remote-cache")
	public String remoteCache() {
		return this.remoteCache;
	}

	/**
	 * The name of the remote cache for which this cache acts as a backup.
	 */
	@SuppressWarnings("unchecked")
	public T remoteCache(String value) {
		this.remoteCache = value;
		return (T) this;
	}

	/**
	 * The site of the remote cache for which this cache acts as a backup.
	 */
	@ModelNodeBinding(detypedName = "remote-site")
	public String remoteSite() {
		return this.remoteSite;
	}

	/**
	 * The site of the remote cache for which this cache acts as a backup.
	 */
	@SuppressWarnings("unchecked")
	public T remoteSite(String value) {
		this.remoteSite = value;
		return (T) this;
	}
}