package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The locking configuration of the cache.
 */
@Address("/subsystem=infinispan/cache-container=*/distributed-cache=*/component=locking")
@Implicit
public class ComponentLocking<T extends ComponentLocking> {

	private String key;
	private Long acquireTimeout;
	private Integer concurrencyLevel;
	private Integer currentConcurrencyLevel;
	private String isolation;
	private Integer numberOfLocksAvailable;
	private Integer numberOfLocksHeld;
	private Boolean striping;

	public ComponentLocking() {
		this.key = "locking";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Maximum time to attempt a particular lock acquisition.
	 */
	@ModelNodeBinding(detypedName = "acquire-timeout")
	public Long acquireTimeout() {
		return this.acquireTimeout;
	}

	/**
	 * Maximum time to attempt a particular lock acquisition.
	 */
	@SuppressWarnings("unchecked")
	public T acquireTimeout(Long value) {
		this.acquireTimeout = value;
		return (T) this;
	}

	/**
	 * Concurrency level for lock containers. Adjust this value according to the number of concurrent threads interacting with Infinispan.
	 */
	@ModelNodeBinding(detypedName = "concurrency-level")
	public Integer concurrencyLevel() {
		return this.concurrencyLevel;
	}

	/**
	 * Concurrency level for lock containers. Adjust this value according to the number of concurrent threads interacting with Infinispan.
	 */
	@SuppressWarnings("unchecked")
	public T concurrencyLevel(Integer value) {
		this.concurrencyLevel = value;
		return (T) this;
	}

	/**
	 * The estimated number of concurrently updating threads which this cache can support. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "current-concurrency-level")
	public Integer currentConcurrencyLevel() {
		return this.currentConcurrencyLevel;
	}

	/**
	 * The estimated number of concurrently updating threads which this cache can support. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T currentConcurrencyLevel(Integer value) {
		this.currentConcurrencyLevel = value;
		return (T) this;
	}

	/**
	 * Sets the cache locking isolation level.
	 */
	@ModelNodeBinding(detypedName = "isolation")
	public String isolation() {
		return this.isolation;
	}

	/**
	 * Sets the cache locking isolation level.
	 */
	@SuppressWarnings("unchecked")
	public T isolation(String value) {
		this.isolation = value;
		return (T) this;
	}

	/**
	 * The number of locks available to this cache. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-locks-available")
	public Integer numberOfLocksAvailable() {
		return this.numberOfLocksAvailable;
	}

	/**
	 * The number of locks available to this cache. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfLocksAvailable(Integer value) {
		this.numberOfLocksAvailable = value;
		return (T) this;
	}

	/**
	 * The number of locks currently in use by this cache. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-locks-held")
	public Integer numberOfLocksHeld() {
		return this.numberOfLocksHeld;
	}

	/**
	 * The number of locks currently in use by this cache. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfLocksHeld(Integer value) {
		this.numberOfLocksHeld = value;
		return (T) this;
	}

	/**
	 * If true, a pool of shared locks is maintained for all entries that need to be locked. Otherwise, a lock is created per entry in the cache. Lock striping helps control memory footprint but may reduce concurrency in the system.
	 */
	@ModelNodeBinding(detypedName = "striping")
	public Boolean striping() {
		return this.striping;
	}

	/**
	 * If true, a pool of shared locks is maintained for all entries that need to be locked. Otherwise, a lock is created per entry in the cache. Lock striping helps control memory footprint but may reduce concurrency in the system.
	 */
	@SuppressWarnings("unchecked")
	public T striping(Boolean value) {
		this.striping = value;
		return (T) this;
	}
}