package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.distributedCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * The state transfer configuration for distributed and replicated caches.
 */
@Address("/subsystem=infinispan/cache-container=*/distributed-cache=*/component=state-transfer")
@Implicit
public class ComponentStateTransfer<T extends ComponentStateTransfer> {

	private String key;
	private Integer chunkSize;
	private Long timeout;

	public ComponentStateTransfer() {
		this.key = "state-transfer";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The size, in bytes, in which to batch the transfer of cache entries.
	 */
	@ModelNodeBinding(detypedName = "chunk-size")
	public Integer chunkSize() {
		return this.chunkSize;
	}

	/**
	 * The size, in bytes, in which to batch the transfer of cache entries.
	 */
	@SuppressWarnings("unchecked")
	public T chunkSize(Integer value) {
		this.chunkSize = value;
		return (T) this;
	}

	/**
	 * The maximum amount of time (ms) to wait for state from neighboring caches, before throwing an exception and aborting startup.
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Long timeout() {
		return this.timeout;
	}

	/**
	 * The maximum amount of time (ms) to wait for state from neighboring caches, before throwing an exception and aborting startup.
	 */
	@SuppressWarnings("unchecked")
	public T timeout(Long value) {
		this.timeout = value;
		return (T) this;
	}
}