package org.wildfly.swarm.config.infinispan.subsystem.cacheContainer.localCache;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.subsystem.infinispan.cacheContainer.localCache.store.stringJdbc.property.Property;
import org.wildfly.swarm.config.infinispan.subsystem.infinispan.cacheContainer.localCache.store.stringJdbc.write.WriteThrough;
import org.wildfly.swarm.config.infinispan.subsystem.infinispan.cacheContainer.localCache.store.stringJdbc.write.WriteBehind;
import org.wildfly.swarm.config.infinispan.subsystem.infinispan.cacheContainer.localCache.store.stringJdbc.table.TableString;
/**
 * The cache JDBC store configuration.
 */
@Address("/subsystem=infinispan/cache-container=*/local-cache=*/store=string-jdbc")
@Implicit
public class StoreStringJdbc<T extends StoreStringJdbc> {

	private String key;
	private Long cacheLoaderLoads;
	private Long cacheLoaderMisses;
	private String datasource;
	private String dialect;
	private Boolean fetchState;
	private Boolean passivation;
	private Boolean preload;
	private Map properties;
	private Boolean purge;
	private Boolean shared;
	private Boolean singleton;
	private StoreStringJdbcResources subresources = new StoreStringJdbcResources();
	private WriteThrough writeThrough;
	private WriteBehind writeBehind;
	private TableString tableString;

	public StoreStringJdbc() {
		this.key = "string-jdbc";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of cache loader node loads. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-loader-loads")
	public Long cacheLoaderLoads() {
		return this.cacheLoaderLoads;
	}

	/**
	 * The number of cache loader node loads. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T cacheLoaderLoads(Long value) {
		this.cacheLoaderLoads = value;
		return (T) this;
	}

	/**
	 * The number of cache loader node misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-loader-misses")
	public Long cacheLoaderMisses() {
		return this.cacheLoaderMisses;
	}

	/**
	 * The number of cache loader node misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T cacheLoaderMisses(Long value) {
		this.cacheLoaderMisses = value;
		return (T) this;
	}

	/**
	 * A datasource reference for this datastore.
	 */
	@ModelNodeBinding(detypedName = "datasource")
	public String datasource() {
		return this.datasource;
	}

	/**
	 * A datasource reference for this datastore.
	 */
	@SuppressWarnings("unchecked")
	public T datasource(String value) {
		this.datasource = value;
		return (T) this;
	}

	/**
	 * The dialect of this datastore.
	 */
	@ModelNodeBinding(detypedName = "dialect")
	public String dialect() {
		return this.dialect;
	}

	/**
	 * The dialect of this datastore.
	 */
	@SuppressWarnings("unchecked")
	public T dialect(String value) {
		this.dialect = value;
		return (T) this;
	}

	/**
	 * If true, fetch persistent state when joining a cluster. If multiple cache stores are chained, only one of them can have this property enabled.
	 */
	@ModelNodeBinding(detypedName = "fetch-state")
	public Boolean fetchState() {
		return this.fetchState;
	}

	/**
	 * If true, fetch persistent state when joining a cluster. If multiple cache stores are chained, only one of them can have this property enabled.
	 */
	@SuppressWarnings("unchecked")
	public T fetchState(Boolean value) {
		this.fetchState = value;
		return (T) this;
	}

	/**
	 * If true, data is only written to the cache store when it is evicted from memory, a phenomenon known as 'passivation'. Next time the data is requested, it will be 'activated' which means that data will be brought back to memory and removed from the persistent store. f false, the cache store contains a copy of the contents in memory, so writes to cache result in cache store writes. This essentially gives you a 'write-through' configuration.
	 */
	@ModelNodeBinding(detypedName = "passivation")
	public Boolean passivation() {
		return this.passivation;
	}

	/**
	 * If true, data is only written to the cache store when it is evicted from memory, a phenomenon known as 'passivation'. Next time the data is requested, it will be 'activated' which means that data will be brought back to memory and removed from the persistent store. f false, the cache store contains a copy of the contents in memory, so writes to cache result in cache store writes. This essentially gives you a 'write-through' configuration.
	 */
	@SuppressWarnings("unchecked")
	public T passivation(Boolean value) {
		this.passivation = value;
		return (T) this;
	}

	/**
	 * If true, when the cache starts, data stored in the cache store will be pre-loaded into memory. This is particularly useful when data in the cache store will be needed immediately after startup and you want to avoid cache operations being delayed as a result of loading this data lazily. Can be used to provide a 'warm-cache' on startup, however there is a performance penalty as startup time is affected by this process.
	 */
	@ModelNodeBinding(detypedName = "preload")
	public Boolean preload() {
		return this.preload;
	}

	/**
	 * If true, when the cache starts, data stored in the cache store will be pre-loaded into memory. This is particularly useful when data in the cache store will be needed immediately after startup and you want to avoid cache operations being delayed as a result of loading this data lazily. Can be used to provide a 'warm-cache' on startup, however there is a performance penalty as startup time is affected by this process.
	 */
	@SuppressWarnings("unchecked")
	public T preload(Boolean value) {
		this.preload = value;
		return (T) this;
	}

	/**
	 * A list of cache store properties.
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * A list of cache store properties.
	 */
	@SuppressWarnings("unchecked")
	public T properties(Map value) {
		this.properties = value;
		return (T) this;
	}

	/**
	 * If true, purges this cache store when it starts up.
	 */
	@ModelNodeBinding(detypedName = "purge")
	public Boolean purge() {
		return this.purge;
	}

	/**
	 * If true, purges this cache store when it starts up.
	 */
	@SuppressWarnings("unchecked")
	public T purge(Boolean value) {
		this.purge = value;
		return (T) this;
	}

	/**
	 * This setting should be set to true when multiple cache instances share the same cache store (e.g., multiple nodes in a cluster using a JDBC-based CacheStore pointing to the same, shared database.) Setting this to true avoids multiple cache instances writing the same modification multiple times. If enabled, only the node where the modification originated will write to the cache store. If disabled, each individual cache reacts to a potential remote update by storing the data to the cache store.
	 */
	@ModelNodeBinding(detypedName = "shared")
	public Boolean shared() {
		return this.shared;
	}

	/**
	 * This setting should be set to true when multiple cache instances share the same cache store (e.g., multiple nodes in a cluster using a JDBC-based CacheStore pointing to the same, shared database.) Setting this to true avoids multiple cache instances writing the same modification multiple times. If enabled, only the node where the modification originated will write to the cache store. If disabled, each individual cache reacts to a potential remote update by storing the data to the cache store.
	 */
	@SuppressWarnings("unchecked")
	public T shared(Boolean value) {
		this.shared = value;
		return (T) this;
	}

	/**
	 * If true, the singleton store cache store is enabled. SingletonStore is a delegating cache store used for situations when only one instance in a cluster should interact with the underlying store.
	 */
	@ModelNodeBinding(detypedName = "singleton")
	public Boolean singleton() {
		return this.singleton;
	}

	/**
	 * If true, the singleton store cache store is enabled. SingletonStore is a delegating cache store used for situations when only one instance in a cluster should interact with the underlying store.
	 */
	@SuppressWarnings("unchecked")
	public T singleton(Boolean value) {
		this.singleton = value;
		return (T) this;
	}

	public StoreStringJdbcResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Property objects to this subresource
	 * @return this
	 * @param value List of Property objects.
	 */
	@SuppressWarnings("unchecked")
	public T propertys(List<Property> value) {
		this.subresources.propertys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Property object to the list of subresources
	 * @param value The Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T property(Property value) {
		this.subresources.propertys.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for StoreStringJdbc
	 */
	public class StoreStringJdbcResources {
		/**
		 * A cache store property with name and value.
		 */
		private List<Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}

	/**
	 * Configures a cache store as write-through.
	 */
	@Subresource
	public WriteThrough writeThrough() {
		return this.writeThrough;
	}

	/**
	 * Configures a cache store as write-through.
	 */
	@SuppressWarnings("unchecked")
	public T writeThrough(WriteThrough value) {
		this.writeThrough = value;
		return (T) this;
	}

	/**
	 * Configures a cache store as write-behind instead of write-through.
	 */
	@Subresource
	public WriteBehind writeBehind() {
		return this.writeBehind;
	}

	/**
	 * Configures a cache store as write-behind instead of write-through.
	 */
	@SuppressWarnings("unchecked")
	public T writeBehind(WriteBehind value) {
		this.writeBehind = value;
		return (T) this;
	}

	/**
	 * Defines a table used to store cache entries whose keys can be expressed as strings.
	 */
	@Subresource
	public TableString tableString() {
		return this.tableString;
	}

	/**
	 * Defines a table used to store cache entries whose keys can be expressed as strings.
	 */
	@SuppressWarnings("unchecked")
	public T tableString(TableString value) {
		this.tableString = value;
		return (T) this;
	}
}