package org.wildfly.swarm.config.infinispan.subsystem.infinispan.cacheContainer.invalidationCache.store.mixedJdbc.write;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Configures a cache store as write-behind instead of write-through.
 */
@Address("/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=mixed-jdbc/write=behind")
@Implicit
public class WriteBehind<T extends WriteBehind> {

	private String key;
	private Integer modificationQueueSize;
	private Integer threadPoolSize;

	public WriteBehind() {
		this.key = "behind";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Maximum number of entries in the asynchronous queue. When the queue is full, the store becomes write-through until it can accept new entries.
	 */
	@ModelNodeBinding(detypedName = "modification-queue-size")
	public Integer modificationQueueSize() {
		return this.modificationQueueSize;
	}

	/**
	 * Maximum number of entries in the asynchronous queue. When the queue is full, the store becomes write-through until it can accept new entries.
	 */
	@SuppressWarnings("unchecked")
	public T modificationQueueSize(Integer value) {
		this.modificationQueueSize = value;
		return (T) this;
	}

	/**
	 * Size of the thread pool whose threads are responsible for applying the modifications to the cache store.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-size")
	public Integer threadPoolSize() {
		return this.threadPoolSize;
	}

	/**
	 * Size of the thread pool whose threads are responsible for applying the modifications to the cache store.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolSize(Integer value) {
		this.threadPoolSize = value;
		return (T) this;
	}
}