package org.wildfly.swarm.config.infinispan.subsystem.infinispan.cacheContainer.invalidationCache.store.stringJdbc.property;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A cache store property with name and value.
 */
@Address("/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=string-jdbc/property=*")
public class Property<T extends Property> {

	private String key;
	private String value;

	public Property(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The value of the cache store property.
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The value of the cache store property.
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		this.value = value;
		return (T) this;
	}
}