package org.wildfly.swarm.config.io.subsystem.worker;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * Defines workers
 */
@Address("/subsystem=io/worker=*")
public class Worker<T extends Worker> {

	private String key;
	private Integer ioThreads;
	private Long stackSize;
	private Integer taskKeepalive;
	private Integer taskMaxThreads;

	public Worker(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Number of IO threads to use
	 */
	@ModelNodeBinding(detypedName = "io-threads")
	public Integer ioThreads() {
		return this.ioThreads;
	}

	/**
	 * Number of IO threads to use
	 */
	@SuppressWarnings("unchecked")
	public T ioThreads(Integer value) {
		this.ioThreads = value;
		return (T) this;
	}

	/**
	 * stack-size
	 */
	@ModelNodeBinding(detypedName = "stack-size")
	public Long stackSize() {
		return this.stackSize;
	}

	/**
	 * stack-size
	 */
	@SuppressWarnings("unchecked")
	public T stackSize(Long value) {
		this.stackSize = value;
		return (T) this;
	}

	/**
	 * task-keepalive
	 */
	@ModelNodeBinding(detypedName = "task-keepalive")
	public Integer taskKeepalive() {
		return this.taskKeepalive;
	}

	/**
	 * task-keepalive
	 */
	@SuppressWarnings("unchecked")
	public T taskKeepalive(Integer value) {
		this.taskKeepalive = value;
		return (T) this;
	}

	/**
	 * task-max-threads
	 */
	@ModelNodeBinding(detypedName = "task-max-threads")
	public Integer taskMaxThreads() {
		return this.taskMaxThreads;
	}

	/**
	 * task-max-threads
	 */
	@SuppressWarnings("unchecked")
	public T taskMaxThreads(Integer value) {
		this.taskMaxThreads = value;
		return (T) this;
	}
}