package org.wildfly.swarm.config.messaging.subsystem.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.subsystem.server.haPolicy.ConfigurationMaster;
import org.wildfly.swarm.config.messaging.subsystem.server.haPolicy.ConfigurationSlave;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@Address("/subsystem=messaging-activemq/server=*/ha-policy=shared-store-colocated")
@Implicit
public class HaPolicySharedStoreColocated<T extends HaPolicySharedStoreColocated> {

	private String key;
	private Integer backupPortOffset;
	private Integer backupRequestRetries;
	private Long backupRequestRetryInterval;
	private Integer maxBackups;
	private Boolean requestBackup;
	private ConfigurationMaster configurationMaster;
	private ConfigurationSlave configurationSlave;

	public HaPolicySharedStoreColocated() {
		this.key = "shared-store-colocated";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The offset to use for the Connectors and Acceptors when creating a new backup server.
	 */
	@ModelNodeBinding(detypedName = "backup-port-offset")
	public Integer backupPortOffset() {
		return this.backupPortOffset;
	}

	/**
	 * The offset to use for the Connectors and Acceptors when creating a new backup server.
	 */
	@SuppressWarnings("unchecked")
	public T backupPortOffset(Integer value) {
		this.backupPortOffset = value;
		return (T) this;
	}

	/**
	 * How many times the live server will try to request a backup, -1 means for ever.
	 */
	@ModelNodeBinding(detypedName = "backup-request-retries")
	public Integer backupRequestRetries() {
		return this.backupRequestRetries;
	}

	/**
	 * How many times the live server will try to request a backup, -1 means for ever.
	 */
	@SuppressWarnings("unchecked")
	public T backupRequestRetries(Integer value) {
		this.backupRequestRetries = value;
		return (T) this;
	}

	/**
	 * How long (in ms) to wait for retries between attempts to request a backup server.
	 */
	@ModelNodeBinding(detypedName = "backup-request-retry-interval")
	public Long backupRequestRetryInterval() {
		return this.backupRequestRetryInterval;
	}

	/**
	 * How long (in ms) to wait for retries between attempts to request a backup server.
	 */
	@SuppressWarnings("unchecked")
	public T backupRequestRetryInterval(Long value) {
		this.backupRequestRetryInterval = value;
		return (T) this;
	}

	/**
	 * Whether or not this live server will accept backup requests from other live servers.
	 */
	@ModelNodeBinding(detypedName = "max-backups")
	public Integer maxBackups() {
		return this.maxBackups;
	}

	/**
	 * Whether or not this live server will accept backup requests from other live servers.
	 */
	@SuppressWarnings("unchecked")
	public T maxBackups(Integer value) {
		this.maxBackups = value;
		return (T) this;
	}

	/**
	 * If true then the server will request a backup on another node.
	 */
	@ModelNodeBinding(detypedName = "request-backup")
	public Boolean requestBackup() {
		return this.requestBackup;
	}

	/**
	 * If true then the server will request a backup on another node.
	 */
	@SuppressWarnings("unchecked")
	public T requestBackup(Boolean value) {
		this.requestBackup = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public ConfigurationMaster configurationMaster() {
		return this.configurationMaster;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T configurationMaster(ConfigurationMaster value) {
		this.configurationMaster = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public ConfigurationSlave configurationSlave() {
		return this.configurationSlave;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T configurationSlave(ConfigurationSlave value) {
		this.configurationSlave = value;
		return (T) this;
	}
}