package org.wildfly.swarm.config.messaging.subsystem.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@Address("/subsystem=messaging-activemq/server=*/ha-policy=shared-store-master")
@Implicit
public class HaPolicySharedStoreMaster<T extends HaPolicySharedStoreMaster> {

	private String key;
	private Long failbackDelay;
	private Boolean failoverOnServerShutdown;

	public HaPolicySharedStoreMaster() {
		this.key = "shared-store-master";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@ModelNodeBinding(detypedName = "failback-delay")
	public Long failbackDelay() {
		return this.failbackDelay;
	}

	/**
	 * delay to wait before failback occurs on (live's) restart
	 */
	@SuppressWarnings("unchecked")
	public T failbackDelay(Long value) {
		this.failbackDelay = value;
		return (T) this;
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@ModelNodeBinding(detypedName = "failover-on-server-shutdown")
	public Boolean failoverOnServerShutdown() {
		return this.failoverOnServerShutdown;
	}

	/**
	 * Whether the server must failover when it is normally shutdown.
	 */
	@SuppressWarnings("unchecked")
	public T failoverOnServerShutdown(Boolean value) {
		this.failoverOnServerShutdown = value;
		return (T) this;
	}
}