package org.wildfly.swarm.config.messaging.subsystem.server;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.subsystem.server.connectorService.ConnectorService;
import org.wildfly.swarm.config.messaging.subsystem.server.httpAcceptor.HttpAcceptor;
import org.wildfly.swarm.config.messaging.subsystem.server.clusterConnection.ClusterConnection;
import org.wildfly.swarm.config.messaging.subsystem.server.broadcastGroup.BroadcastGroup;
import org.wildfly.swarm.config.messaging.subsystem.server.runtimeQueue.RuntimeQueue;
import org.wildfly.swarm.config.messaging.subsystem.server.addressSetting.AddressSetting;
import org.wildfly.swarm.config.messaging.subsystem.server.jmsQueue.JmsQueue;
import org.wildfly.swarm.config.messaging.subsystem.server.pooledConnectionFactory.PooledConnectionFactory;
import org.wildfly.swarm.config.messaging.subsystem.server.divert.Divert;
import org.wildfly.swarm.config.messaging.subsystem.server.inVmAcceptor.InVmAcceptor;
import org.wildfly.swarm.config.messaging.subsystem.server.discoveryGroup.DiscoveryGroup;
import org.wildfly.swarm.config.messaging.subsystem.server.httpConnector.HttpConnector;
import org.wildfly.swarm.config.messaging.subsystem.server.connectionFactory.ConnectionFactory;
import org.wildfly.swarm.config.messaging.subsystem.server.acceptor.Acceptor;
import org.wildfly.swarm.config.messaging.subsystem.server.remoteAcceptor.RemoteAcceptor;
import org.wildfly.swarm.config.messaging.subsystem.server.remoteConnector.RemoteConnector;
import org.wildfly.swarm.config.messaging.subsystem.server.inVmConnector.InVmConnector;
import org.wildfly.swarm.config.messaging.subsystem.server.legacyConnectionFactory.LegacyConnectionFactory;
import org.wildfly.swarm.config.messaging.subsystem.server.groupingHandler.GroupingHandler;
import org.wildfly.swarm.config.messaging.subsystem.server.jmsTopic.JmsTopic;
import org.wildfly.swarm.config.messaging.subsystem.server.connector.Connector;
import org.wildfly.swarm.config.messaging.subsystem.server.securitySetting.SecuritySetting;
import org.wildfly.swarm.config.messaging.subsystem.server.coreAddress.CoreAddress;
import org.wildfly.swarm.config.messaging.subsystem.server.bridge.Bridge;
import org.wildfly.swarm.config.messaging.subsystem.server.queue.Queue;
import org.wildfly.swarm.config.messaging.subsystem.server.HaPolicySharedStoreColocated;
import org.wildfly.swarm.config.messaging.subsystem.server.HaPolicyReplicationMaster;
import org.wildfly.swarm.config.messaging.subsystem.server.HaPolicySharedStoreMaster;
import org.wildfly.swarm.config.messaging.subsystem.server.PathBindingsDirectory;
import org.wildfly.swarm.config.messaging.subsystem.server.HaPolicyReplicationColocated;
import org.wildfly.swarm.config.messaging.subsystem.server.PathJournalDirectory;
import org.wildfly.swarm.config.messaging.subsystem.server.HaPolicySharedStoreSlave;
import org.wildfly.swarm.config.messaging.subsystem.server.PathPagingDirectory;
import org.wildfly.swarm.config.messaging.subsystem.server.PathLargeMessagesDirectory;
import org.wildfly.swarm.config.messaging.subsystem.server.HaPolicyLiveOnly;
import org.wildfly.swarm.config.messaging.subsystem.server.HaPolicyReplicationSlave;
/**
 * An ActiveMQ server instance.
 */
@Address("/subsystem=messaging-activemq/server=*")
public class Server<T extends Server> {

	private String key;
	private Boolean active;
	private Boolean asyncConnectionExecutionEnabled;
	private Long connectionTtlOverride;
	private Integer idCacheSize;
	private List<java.util.Map> incomingInterceptors;
	private List<java.util.Map> outgoingInterceptors;
	private Integer pageMaxConcurrentIo;
	private Boolean persistDeliveryCountBeforeDelivery;
	private Boolean persistIdCache;
	private Boolean persistenceEnabled;
	private Integer scheduledThreadPoolMaxSize;
	private Boolean started;
	private Integer threadPoolMaxSize;
	private String version;
	private Boolean wildCardRoutingEnabled;
	private String clusterPassword;
	private String clusterUser;
	private Long memoryMeasureInterval;
	private Integer memoryWarningThreshold;
	private Integer perfBlastPages;
	private Boolean runSyncSpeedTest;
	private Long serverDumpInterval;
	private Boolean createBindingsDir;
	private Boolean createJournalDir;
	private Long journalBufferSize;
	private Long journalBufferTimeout;
	private Integer journalCompactMinFiles;
	private Integer journalCompactPercentage;
	private Long journalFileSize;
	private Integer journalMaxIo;
	private Integer journalMinFiles;
	private Boolean journalSyncNonTransactional;
	private Boolean journalSyncTransactional;
	private String journalType;
	private Boolean logJournalWriteRate;
	private String jmxDomain;
	private Boolean jmxManagementEnabled;
	private String managementAddress;
	private String managementNotificationAddress;
	private Long messageExpiryScanPeriod;
	private Integer messageExpiryThreadPriority;
	private Boolean overrideInVmSecurity;
	private String securityDomain;
	private Boolean securityEnabled;
	private Long securityInvalidationInterval;
	private Integer messageCounterMaxDayHistory;
	private Long messageCounterSamplePeriod;
	private Boolean statisticsEnabled;
	private Long transactionTimeout;
	private Long transactionTimeoutScanPeriod;
	private ServerResources subresources = new ServerResources();
	private HaPolicySharedStoreColocated haPolicySharedStoreColocated;
	private HaPolicyReplicationMaster haPolicyReplicationMaster;
	private HaPolicySharedStoreMaster haPolicySharedStoreMaster;
	private PathBindingsDirectory pathBindingsDirectory;
	private HaPolicyReplicationColocated haPolicyReplicationColocated;
	private PathJournalDirectory pathJournalDirectory;
	private HaPolicySharedStoreSlave haPolicySharedStoreSlave;
	private PathPagingDirectory pathPagingDirectory;
	private PathLargeMessagesDirectory pathLargeMessagesDirectory;
	private HaPolicyLiveOnly haPolicyLiveOnly;
	private HaPolicyReplicationSlave haPolicyReplicationSlave;

	public Server(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in backup mode, waiting for failover).
	 */
	@ModelNodeBinding(detypedName = "active")
	public Boolean active() {
		return this.active;
	}

	/**
	 * Whether the server is active (and accepting connections) or passive (in backup mode, waiting for failover).
	 */
	@SuppressWarnings("unchecked")
	public T active(Boolean value) {
		this.active = value;
		return (T) this;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread from the thread pool for processing. False if they should be handled on the remoting thread.
	 */
	@ModelNodeBinding(detypedName = "async-connection-execution-enabled")
	public Boolean asyncConnectionExecutionEnabled() {
		return this.asyncConnectionExecutionEnabled;
	}

	/**
	 * Whether incoming packets on the server should be handed off to a thread from the thread pool for processing. False if they should be handled on the remoting thread.
	 */
	@SuppressWarnings("unchecked")
	public T asyncConnectionExecutionEnabled(Boolean value) {
		this.asyncConnectionExecutionEnabled = value;
		return (T) this;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive without receiving a ping.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl-override")
	public Long connectionTtlOverride() {
		return this.connectionTtlOverride;
	}

	/**
	 * If set, this will override how long (in ms) to keep a connection alive without receiving a ping.
	 */
	@SuppressWarnings("unchecked")
	public T connectionTtlOverride(Long value) {
		this.connectionTtlOverride = value;
		return (T) this;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@ModelNodeBinding(detypedName = "id-cache-size")
	public Integer idCacheSize() {
		return this.idCacheSize;
	}

	/**
	 * The size of the cache for pre-creating message IDs.
	 */
	@SuppressWarnings("unchecked")
	public T idCacheSize(Integer value) {
		this.idCacheSize = value;
		return (T) this;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "incoming-interceptors")
	public List<Map> incomingInterceptors() {
		return this.incomingInterceptors;
	}

	/**
	 * The list of incoming interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T incomingInterceptors(List<java.util.Map> value) {
		this.incomingInterceptors = value;
		return (T) this;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@ModelNodeBinding(detypedName = "outgoing-interceptors")
	public List<Map> outgoingInterceptors() {
		return this.outgoingInterceptors;
	}

	/**
	 * The list of outgoing interceptor classes used by this server.
	 */
	@SuppressWarnings("unchecked")
	public T outgoingInterceptors(List<java.util.Map> value) {
		this.outgoingInterceptors = value;
		return (T) this;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@ModelNodeBinding(detypedName = "page-max-concurrent-io")
	public Integer pageMaxConcurrentIo() {
		return this.pageMaxConcurrentIo;
	}

	/**
	 * The maximum number of concurrent reads allowed on paging
	 */
	@SuppressWarnings("unchecked")
	public T pageMaxConcurrentIo(Integer value) {
		this.pageMaxConcurrentIo = value;
		return (T) this;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.
	 */
	@ModelNodeBinding(detypedName = "persist-delivery-count-before-delivery")
	public Boolean persistDeliveryCountBeforeDelivery() {
		return this.persistDeliveryCountBeforeDelivery;
	}

	/**
	 * Whether the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.
	 */
	@SuppressWarnings("unchecked")
	public T persistDeliveryCountBeforeDelivery(Boolean value) {
		this.persistDeliveryCountBeforeDelivery = value;
		return (T) this;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@ModelNodeBinding(detypedName = "persist-id-cache")
	public Boolean persistIdCache() {
		return this.persistIdCache;
	}

	/**
	 * Whether IDs are persisted to the journal.
	 */
	@SuppressWarnings("unchecked")
	public T persistIdCache(Boolean value) {
		this.persistIdCache = value;
		return (T) this;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@ModelNodeBinding(detypedName = "persistence-enabled")
	public Boolean persistenceEnabled() {
		return this.persistenceEnabled;
	}

	/**
	 * Whether the server will use the file based journal for persistence.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceEnabled(Boolean value) {
		this.persistenceEnabled = value;
		return (T) this;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The number of threads that the main scheduled thread pool has.
	 */
	@SuppressWarnings("unchecked")
	public T scheduledThreadPoolMaxSize(Integer value) {
		this.scheduledThreadPoolMaxSize = value;
		return (T) this;
	}

	/**
	 * Whether this server is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this server is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(Boolean value) {
		this.started = value;
		return (T) this;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The number of threads that the main thread pool has. -1 means no limit.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolMaxSize(Integer value) {
		this.threadPoolMaxSize = value;
		return (T) this;
	}

	/**
	 * The server's version.
	 */
	@ModelNodeBinding(detypedName = "version")
	public String version() {
		return this.version;
	}

	/**
	 * The server's version.
	 */
	@SuppressWarnings("unchecked")
	public T version(String value) {
		this.version = value;
		return (T) this;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@ModelNodeBinding(detypedName = "wild-card-routing-enabled")
	public Boolean wildCardRoutingEnabled() {
		return this.wildCardRoutingEnabled;
	}

	/**
	 * Whether the server supports wild card routing.
	 */
	@SuppressWarnings("unchecked")
	public T wildCardRoutingEnabled(Boolean value) {
		this.wildCardRoutingEnabled = value;
		return (T) this;
	}

	/**
	 * The password used by cluster connections to communicate between the clustered nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-password")
	public String clusterPassword() {
		return this.clusterPassword;
	}

	/**
	 * The password used by cluster connections to communicate between the clustered nodes.
	 */
	@SuppressWarnings("unchecked")
	public T clusterPassword(String value) {
		this.clusterPassword = value;
		return (T) this;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered nodes.
	 */
	@ModelNodeBinding(detypedName = "cluster-user")
	public String clusterUser() {
		return this.clusterUser;
	}

	/**
	 * The user used by cluster connections to communicate between the clustered nodes.
	 */
	@SuppressWarnings("unchecked")
	public T clusterUser(String value) {
		this.clusterUser = value;
		return (T) this;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@ModelNodeBinding(detypedName = "memory-measure-interval")
	public Long memoryMeasureInterval() {
		return this.memoryMeasureInterval;
	}

	/**
	 * Frequency to sample JVM memory in ms (or -1 to disable memory sampling)
	 */
	@SuppressWarnings("unchecked")
	public T memoryMeasureInterval(Long value) {
		this.memoryMeasureInterval = value;
		return (T) this;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@ModelNodeBinding(detypedName = "memory-warning-threshold")
	public Integer memoryWarningThreshold() {
		return this.memoryWarningThreshold;
	}

	/**
	 * Percentage of available memory which if exceeded results in a warning log
	 */
	@SuppressWarnings("unchecked")
	public T memoryWarningThreshold(Integer value) {
		this.memoryWarningThreshold = value;
		return (T) this;
	}

	/**
	 * TODO
	 */
	@ModelNodeBinding(detypedName = "perf-blast-pages")
	public Integer perfBlastPages() {
		return this.perfBlastPages;
	}

	/**
	 * TODO
	 */
	@SuppressWarnings("unchecked")
	public T perfBlastPages(Integer value) {
		this.perfBlastPages = value;
		return (T) this;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can sync. Useful when determining performance issues.
	 */
	@ModelNodeBinding(detypedName = "run-sync-speed-test")
	public Boolean runSyncSpeedTest() {
		return this.runSyncSpeedTest;
	}

	/**
	 * Whether on startup to perform a diagnostic test on how fast your disk can sync. Useful when determining performance issues.
	 */
	@SuppressWarnings("unchecked")
	public T runSyncSpeedTest(Boolean value) {
		this.runSyncSpeedTest = value;
		return (T) this;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value less than 1 disables this feature.
	 */
	@ModelNodeBinding(detypedName = "server-dump-interval")
	public Long serverDumpInterval() {
		return this.serverDumpInterval;
	}

	/**
	 * How often to dump basic runtime information to the server log. A value less than 1 disables this feature.
	 */
	@SuppressWarnings("unchecked")
	public T serverDumpInterval(Long value) {
		this.serverDumpInterval = value;
		return (T) this;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-bindings-dir")
	public Boolean createBindingsDir() {
		return this.createBindingsDir;
	}

	/**
	 * Whether the server should create the bindings directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public T createBindingsDir(Boolean value) {
		this.createBindingsDir = value;
		return (T) this;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@ModelNodeBinding(detypedName = "create-journal-dir")
	public Boolean createJournalDir() {
		return this.createJournalDir;
	}

	/**
	 * Whether the server should create the journal directory on start up.
	 */
	@SuppressWarnings("unchecked")
	public T createJournalDir(Boolean value) {
		this.createJournalDir = value;
		return (T) this;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-size")
	public Long journalBufferSize() {
		return this.journalBufferSize;
	}

	/**
	 * The size of the internal buffer on the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalBufferSize(Long value) {
		this.journalBufferSize = value;
		return (T) this;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-buffer-timeout")
	public Long journalBufferTimeout() {
		return this.journalBufferTimeout;
	}

	/**
	 * The timeout (in nanoseconds) used to flush internal buffers on the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalBufferTimeout(Long value) {
		this.journalBufferTimeout = value;
		return (T) this;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-min-files")
	public Integer journalCompactMinFiles() {
		return this.journalCompactMinFiles;
	}

	/**
	 * The minimal number of journal data files before we can start compacting.
	 */
	@SuppressWarnings("unchecked")
	public T journalCompactMinFiles(Integer value) {
		this.journalCompactMinFiles = value;
		return (T) this;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@ModelNodeBinding(detypedName = "journal-compact-percentage")
	public Integer journalCompactPercentage() {
		return this.journalCompactPercentage;
	}

	/**
	 * The percentage of live data on which we consider compacting the journal.
	 */
	@SuppressWarnings("unchecked")
	public T journalCompactPercentage(Integer value) {
		this.journalCompactPercentage = value;
		return (T) this;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@ModelNodeBinding(detypedName = "journal-file-size")
	public Long journalFileSize() {
		return this.journalFileSize;
	}

	/**
	 * The size (in bytes) of each journal file.
	 */
	@SuppressWarnings("unchecked")
	public T journalFileSize(Long value) {
		this.journalFileSize = value;
		return (T) this;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any one time.
	 */
	@ModelNodeBinding(detypedName = "journal-max-io")
	public Integer journalMaxIo() {
		return this.journalMaxIo;
	}

	/**
	 * The maximum number of write requests that can be in the AIO queue at any one time.
	 */
	@SuppressWarnings("unchecked")
	public T journalMaxIo(Integer value) {
		this.journalMaxIo = value;
		return (T) this;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@ModelNodeBinding(detypedName = "journal-min-files")
	public Integer journalMinFiles() {
		return this.journalMinFiles;
	}

	/**
	 * How many journal files to pre-create.
	 */
	@SuppressWarnings("unchecked")
	public T journalMinFiles(Integer value) {
		this.journalMinFiles = value;
		return (T) this;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-non-transactional")
	public Boolean journalSyncNonTransactional() {
		return this.journalSyncNonTransactional;
	}

	/**
	 * Whether to wait for non transaction data to be synced to the journal before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public T journalSyncNonTransactional(Boolean value) {
		this.journalSyncNonTransactional = value;
		return (T) this;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal before returning a response to the client.
	 */
	@ModelNodeBinding(detypedName = "journal-sync-transactional")
	public Boolean journalSyncTransactional() {
		return this.journalSyncTransactional;
	}

	/**
	 * Whether to wait for transaction data to be synchronized to the journal before returning a response to the client.
	 */
	@SuppressWarnings("unchecked")
	public T journalSyncTransactional(Boolean value) {
		this.journalSyncTransactional = value;
		return (T) this;
	}

	/**
	 * The type of journal to use.
	 */
	@ModelNodeBinding(detypedName = "journal-type")
	public String journalType() {
		return this.journalType;
	}

	/**
	 * The type of journal to use.
	 */
	@SuppressWarnings("unchecked")
	public T journalType(String value) {
		this.journalType = value;
		return (T) this;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@ModelNodeBinding(detypedName = "log-journal-write-rate")
	public Boolean logJournalWriteRate() {
		return this.logJournalWriteRate;
	}

	/**
	 * Whether to periodically log the journal's write rate and flush rate.
	 */
	@SuppressWarnings("unchecked")
	public T logJournalWriteRate(Boolean value) {
		this.logJournalWriteRate = value;
		return (T) this;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the MBeanServer.
	 */
	@ModelNodeBinding(detypedName = "jmx-domain")
	public String jmxDomain() {
		return this.jmxDomain;
	}

	/**
	 * The JMX domain used to register internal ActiveMQ MBeans in the MBeanServer.
	 */
	@SuppressWarnings("unchecked")
	public T jmxDomain(String value) {
		this.jmxDomain = value;
		return (T) this;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This is not recommended, as accessing these MBeans can lead to inconsistent configuration.
	 */
	@ModelNodeBinding(detypedName = "jmx-management-enabled")
	public Boolean jmxManagementEnabled() {
		return this.jmxManagementEnabled;
	}

	/**
	 * Whether ActiveMQ should expose its internal management API via JMX. This is not recommended, as accessing these MBeans can lead to inconsistent configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jmxManagementEnabled(Boolean value) {
		this.jmxManagementEnabled = value;
		return (T) this;
	}

	/**
	 * Address to send management messages to.
	 */
	@ModelNodeBinding(detypedName = "management-address")
	public String managementAddress() {
		return this.managementAddress;
	}

	/**
	 * Address to send management messages to.
	 */
	@SuppressWarnings("unchecked")
	public T managementAddress(String value) {
		this.managementAddress = value;
		return (T) this;
	}

	/**
	 * The name of the address that consumers bind to  to receive management notifications.
	 */
	@ModelNodeBinding(detypedName = "management-notification-address")
	public String managementNotificationAddress() {
		return this.managementNotificationAddress;
	}

	/**
	 * The name of the address that consumers bind to  to receive management notifications.
	 */
	@SuppressWarnings("unchecked")
	public T managementNotificationAddress(String value) {
		this.managementNotificationAddress = value;
		return (T) this;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-scan-period")
	public Long messageExpiryScanPeriod() {
		return this.messageExpiryScanPeriod;
	}

	/**
	 * How often (in ms) to scan for expired messages.
	 */
	@SuppressWarnings("unchecked")
	public T messageExpiryScanPeriod(Long value) {
		this.messageExpiryScanPeriod = value;
		return (T) this;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@ModelNodeBinding(detypedName = "message-expiry-thread-priority")
	public Integer messageExpiryThreadPriority() {
		return this.messageExpiryThreadPriority;
	}

	/**
	 * The priority of the thread expiring messages.
	 */
	@SuppressWarnings("unchecked")
	public T messageExpiryThreadPriority(Integer value) {
		this.messageExpiryThreadPriority = value;
		return (T) this;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm connections.
	 */
	@ModelNodeBinding(detypedName = "override-in-vm-security")
	public Boolean overrideInVmSecurity() {
		return this.overrideInVmSecurity;
	}

	/**
	 * Whether the ActiveMQ server will override security credentials for in-vm connections.
	 */
	@SuppressWarnings("unchecked")
	public T overrideInVmSecurity(Boolean value) {
		this.overrideInVmSecurity = value;
		return (T) this;
	}

	/**
	 * The security domain to use to verify user and role information
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * The security domain to use to verify user and role information
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(String value) {
		this.securityDomain = value;
		return (T) this;
	}

	/**
	 * Whether security is enabled.
	 */
	@ModelNodeBinding(detypedName = "security-enabled")
	public Boolean securityEnabled() {
		return this.securityEnabled;
	}

	/**
	 * Whether security is enabled.
	 */
	@SuppressWarnings("unchecked")
	public T securityEnabled(Boolean value) {
		this.securityEnabled = value;
		return (T) this;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@ModelNodeBinding(detypedName = "security-invalidation-interval")
	public Long securityInvalidationInterval() {
		return this.securityInvalidationInterval;
	}

	/**
	 * How long (in ms) to wait before invalidating the security cache.
	 */
	@SuppressWarnings("unchecked")
	public T securityInvalidationInterval(Long value) {
		this.securityInvalidationInterval = value;
		return (T) this;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@ModelNodeBinding(detypedName = "message-counter-max-day-history")
	public Integer messageCounterMaxDayHistory() {
		return this.messageCounterMaxDayHistory;
	}

	/**
	 * How many days to keep message counter history.
	 */
	@SuppressWarnings("unchecked")
	public T messageCounterMaxDayHistory(Integer value) {
		this.messageCounterMaxDayHistory = value;
		return (T) this;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@ModelNodeBinding(detypedName = "message-counter-sample-period")
	public Long messageCounterSamplePeriod() {
		return this.messageCounterSamplePeriod;
	}

	/**
	 * The sample period (in ms) to use for message counters.
	 */
	@SuppressWarnings("unchecked")
	public T messageCounterSamplePeriod(Long value) {
		this.messageCounterSamplePeriod = value;
		return (T) this;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Whether gathering of statistics such as message counters are enabled.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (T) this;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource manager after create time.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout")
	public Long transactionTimeout() {
		return this.transactionTimeout;
	}

	/**
	 * How long (in ms) before a transaction can be removed from the resource manager after create time.
	 */
	@SuppressWarnings("unchecked")
	public T transactionTimeout(Long value) {
		this.transactionTimeout = value;
		return (T) this;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@ModelNodeBinding(detypedName = "transaction-timeout-scan-period")
	public Long transactionTimeoutScanPeriod() {
		return this.transactionTimeoutScanPeriod;
	}

	/**
	 * How often (in ms) to scan for timeout transactions.
	 */
	@SuppressWarnings("unchecked")
	public T transactionTimeoutScanPeriod(Long value) {
		this.transactionTimeoutScanPeriod = value;
		return (T) this;
	}

	public ServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ConnectorService objects to this subresource
	 * @return this
	 * @param value List of ConnectorService objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectorServices(List<ConnectorService> value) {
		this.subresources.connectorServices.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ConnectorService object to the list of subresources
	 * @param value The ConnectorService to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectorService(ConnectorService value) {
		this.subresources.connectorServices.add(value);
		return (T) this;
	}

	/**
	 * Add all HttpAcceptor objects to this subresource
	 * @return this
	 * @param value List of HttpAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptors(List<HttpAcceptor> value) {
		this.subresources.httpAcceptors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the HttpAcceptor object to the list of subresources
	 * @param value The HttpAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpAcceptor(HttpAcceptor value) {
		this.subresources.httpAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Add all ClusterConnection objects to this subresource
	 * @return this
	 * @param value List of ClusterConnection objects.
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnections(List<ClusterConnection> value) {
		this.subresources.clusterConnections.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ClusterConnection object to the list of subresources
	 * @param value The ClusterConnection to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T clusterConnection(ClusterConnection value) {
		this.subresources.clusterConnections.add(value);
		return (T) this;
	}

	/**
	 * Add all BroadcastGroup objects to this subresource
	 * @return this
	 * @param value List of BroadcastGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroups(List<BroadcastGroup> value) {
		this.subresources.broadcastGroups.addAll(value);
		return (T) this;
	}

	/**
	 * Add the BroadcastGroup object to the list of subresources
	 * @param value The BroadcastGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T broadcastGroup(BroadcastGroup value) {
		this.subresources.broadcastGroups.add(value);
		return (T) this;
	}

	/**
	 * Add all RuntimeQueue objects to this subresource
	 * @return this
	 * @param value List of RuntimeQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueues(List<RuntimeQueue> value) {
		this.subresources.runtimeQueues.addAll(value);
		return (T) this;
	}

	/**
	 * Add the RuntimeQueue object to the list of subresources
	 * @param value The RuntimeQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T runtimeQueue(RuntimeQueue value) {
		this.subresources.runtimeQueues.add(value);
		return (T) this;
	}

	/**
	 * Add all AddressSetting objects to this subresource
	 * @return this
	 * @param value List of AddressSetting objects.
	 */
	@SuppressWarnings("unchecked")
	public T addressSettings(List<AddressSetting> value) {
		this.subresources.addressSettings.addAll(value);
		return (T) this;
	}

	/**
	 * Add the AddressSetting object to the list of subresources
	 * @param value The AddressSetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T addressSetting(AddressSetting value) {
		this.subresources.addressSettings.add(value);
		return (T) this;
	}

	/**
	 * Add all JmsQueue objects to this subresource
	 * @return this
	 * @param value List of JmsQueue objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueues(List<JmsQueue> value) {
		this.subresources.jmsQueues.addAll(value);
		return (T) this;
	}

	/**
	 * Add the JmsQueue object to the list of subresources
	 * @param value The JmsQueue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsQueue(JmsQueue value) {
		this.subresources.jmsQueues.add(value);
		return (T) this;
	}

	/**
	 * Add all PooledConnectionFactory objects to this subresource
	 * @return this
	 * @param value List of PooledConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactorys(List<PooledConnectionFactory> value) {
		this.subresources.pooledConnectionFactorys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the PooledConnectionFactory object to the list of subresources
	 * @param value The PooledConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T pooledConnectionFactory(PooledConnectionFactory value) {
		this.subresources.pooledConnectionFactorys.add(value);
		return (T) this;
	}

	/**
	 * Add all Divert objects to this subresource
	 * @return this
	 * @param value List of Divert objects.
	 */
	@SuppressWarnings("unchecked")
	public T diverts(List<Divert> value) {
		this.subresources.diverts.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Divert object to the list of subresources
	 * @param value The Divert to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T divert(Divert value) {
		this.subresources.diverts.add(value);
		return (T) this;
	}

	/**
	 * Add all InVmAcceptor objects to this subresource
	 * @return this
	 * @param value List of InVmAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptors(List<InVmAcceptor> value) {
		this.subresources.inVmAcceptors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the InVmAcceptor object to the list of subresources
	 * @param value The InVmAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmAcceptor(InVmAcceptor value) {
		this.subresources.inVmAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Add all DiscoveryGroup objects to this subresource
	 * @return this
	 * @param value List of DiscoveryGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroups(List<DiscoveryGroup> value) {
		this.subresources.discoveryGroups.addAll(value);
		return (T) this;
	}

	/**
	 * Add the DiscoveryGroup object to the list of subresources
	 * @param value The DiscoveryGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(DiscoveryGroup value) {
		this.subresources.discoveryGroups.add(value);
		return (T) this;
	}

	/**
	 * Add all HttpConnector objects to this subresource
	 * @return this
	 * @param value List of HttpConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpConnectors(List<HttpConnector> value) {
		this.subresources.httpConnectors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the HttpConnector object to the list of subresources
	 * @param value The HttpConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpConnector(HttpConnector value) {
		this.subresources.httpConnectors.add(value);
		return (T) this;
	}

	/**
	 * Add all ConnectionFactory objects to this subresource
	 * @return this
	 * @param value List of ConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactorys(List<ConnectionFactory> value) {
		this.subresources.connectionFactorys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ConnectionFactory object to the list of subresources
	 * @param value The ConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionFactory(ConnectionFactory value) {
		this.subresources.connectionFactorys.add(value);
		return (T) this;
	}

	/**
	 * Add all Acceptor objects to this subresource
	 * @return this
	 * @param value List of Acceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T acceptors(List<Acceptor> value) {
		this.subresources.acceptors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Acceptor object to the list of subresources
	 * @param value The Acceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T acceptor(Acceptor value) {
		this.subresources.acceptors.add(value);
		return (T) this;
	}

	/**
	 * Add all RemoteAcceptor objects to this subresource
	 * @return this
	 * @param value List of RemoteAcceptor objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptors(List<RemoteAcceptor> value) {
		this.subresources.remoteAcceptors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the RemoteAcceptor object to the list of subresources
	 * @param value The RemoteAcceptor to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteAcceptor(RemoteAcceptor value) {
		this.subresources.remoteAcceptors.add(value);
		return (T) this;
	}

	/**
	 * Add all RemoteConnector objects to this subresource
	 * @return this
	 * @param value List of RemoteConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnectors(List<RemoteConnector> value) {
		this.subresources.remoteConnectors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the RemoteConnector object to the list of subresources
	 * @param value The RemoteConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteConnector(RemoteConnector value) {
		this.subresources.remoteConnectors.add(value);
		return (T) this;
	}

	/**
	 * Add all InVmConnector objects to this subresource
	 * @return this
	 * @param value List of InVmConnector objects.
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnectors(List<InVmConnector> value) {
		this.subresources.inVmConnectors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the InVmConnector object to the list of subresources
	 * @param value The InVmConnector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T inVmConnector(InVmConnector value) {
		this.subresources.inVmConnectors.add(value);
		return (T) this;
	}

	/**
	 * Add all LegacyConnectionFactory objects to this subresource
	 * @return this
	 * @param value List of LegacyConnectionFactory objects.
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactorys(List<LegacyConnectionFactory> value) {
		this.subresources.legacyConnectionFactorys.addAll(value);
		return (T) this;
	}

	/**
	 * Add the LegacyConnectionFactory object to the list of subresources
	 * @param value The LegacyConnectionFactory to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T legacyConnectionFactory(LegacyConnectionFactory value) {
		this.subresources.legacyConnectionFactorys.add(value);
		return (T) this;
	}

	/**
	 * Add all GroupingHandler objects to this subresource
	 * @return this
	 * @param value List of GroupingHandler objects.
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandlers(List<GroupingHandler> value) {
		this.subresources.groupingHandlers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the GroupingHandler object to the list of subresources
	 * @param value The GroupingHandler to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T groupingHandler(GroupingHandler value) {
		this.subresources.groupingHandlers.add(value);
		return (T) this;
	}

	/**
	 * Add all JmsTopic objects to this subresource
	 * @return this
	 * @param value List of JmsTopic objects.
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopics(List<JmsTopic> value) {
		this.subresources.jmsTopics.addAll(value);
		return (T) this;
	}

	/**
	 * Add the JmsTopic object to the list of subresources
	 * @param value The JmsTopic to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jmsTopic(JmsTopic value) {
		this.subresources.jmsTopics.add(value);
		return (T) this;
	}

	/**
	 * Add all Connector objects to this subresource
	 * @return this
	 * @param value List of Connector objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(List<Connector> value) {
		this.subresources.connectors.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Connector object to the list of subresources
	 * @param value The Connector to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connector(Connector value) {
		this.subresources.connectors.add(value);
		return (T) this;
	}

	/**
	 * Add all SecuritySetting objects to this subresource
	 * @return this
	 * @param value List of SecuritySetting objects.
	 */
	@SuppressWarnings("unchecked")
	public T securitySettings(List<SecuritySetting> value) {
		this.subresources.securitySettings.addAll(value);
		return (T) this;
	}

	/**
	 * Add the SecuritySetting object to the list of subresources
	 * @param value The SecuritySetting to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securitySetting(SecuritySetting value) {
		this.subresources.securitySettings.add(value);
		return (T) this;
	}

	/**
	 * Add all CoreAddress objects to this subresource
	 * @return this
	 * @param value List of CoreAddress objects.
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(List<CoreAddress> value) {
		this.subresources.coreAddress.addAll(value);
		return (T) this;
	}

	/**
	 * Add the CoreAddress object to the list of subresources
	 * @param value The CoreAddress to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T coreAddress(CoreAddress value) {
		this.subresources.coreAddress.add(value);
		return (T) this;
	}

	/**
	 * Add all Bridge objects to this subresource
	 * @return this
	 * @param value List of Bridge objects.
	 */
	@SuppressWarnings("unchecked")
	public T bridges(List<Bridge> value) {
		this.subresources.bridges.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Bridge object to the list of subresources
	 * @param value The Bridge to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bridge(Bridge value) {
		this.subresources.bridges.add(value);
		return (T) this;
	}

	/**
	 * Add all Queue objects to this subresource
	 * @return this
	 * @param value List of Queue objects.
	 */
	@SuppressWarnings("unchecked")
	public T queues(List<Queue> value) {
		this.subresources.queues.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Queue object to the list of subresources
	 * @param value The Queue to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T queue(Queue value) {
		this.subresources.queues.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Server
	 */
	public class ServerResources {
		/**
		 * TODO
		 */
		private List<ConnectorService> connectorServices = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ server over HTTP.
		 */
		private List<HttpAcceptor> httpAcceptors = new java.util.ArrayList<>();
		/**
		 * Cluster connections group servers into clusters so that messages can be load balanced between the nodes of the cluster.
		 */
		private List<ClusterConnection> clusterConnections = new java.util.ArrayList<>();
		/**
		 * A broadcast group is the means by which a server broadcasts connectors over the network.
		 */
		private List<BroadcastGroup> broadcastGroups = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		private List<RuntimeQueue> runtimeQueues = new java.util.ArrayList<>();
		/**
		 * An address setting defines some attributes that are defined against an address wildcard rather than a specific queue.
		 */
		private List<AddressSetting> addressSettings = new java.util.ArrayList<>();
		/**
		 * Defines a JMS queue.
		 */
		private List<JmsQueue> jmsQueues = new java.util.ArrayList<>();
		/**
		 * Defines a managed connection factory.
		 */
		private List<PooledConnectionFactory> pooledConnectionFactorys = new java.util.ArrayList<>();
		/**
		 * A messaging resource that allows you to transparently divert messages routed to one address to some other address, without making any changes to any client application logic.
		 */
		private List<Divert> diverts = new java.util.ArrayList<>();
		/**
		 * Defines a way in which in-VM connections can be made to the ActiveMQ server.
		 */
		private List<InVmAcceptor> inVmAcceptors = new java.util.ArrayList<>();
		/**
		 * Multicast group to listen to receive broadcast from other servers announcing their connectors.
		 */
		private List<DiscoveryGroup> discoveryGroups = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server over HTTP.
		 */
		private List<HttpConnector> httpConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		private List<ConnectionFactory> connectionFactorys = new java.util.ArrayList<>();
		/**
		 * An acceptor defines a way in which connections can be made to the ActiveMQ server.
		 */
		private List<Acceptor> acceptors = new java.util.ArrayList<>();
		/**
		 * Defines a way in which remote connections can be made to the ActiveMQ server.
		 */
		private List<RemoteAcceptor> remoteAcceptors = new java.util.ArrayList<>();
		/**
		 * Used by a remote client to define how it connects to a server.
		 */
		private List<RemoteConnector> remoteConnectors = new java.util.ArrayList<>();
		/**
		 * Used by an in-VM client to define how it connects to a server.
		 */
		private List<InVmConnector> inVmConnectors = new java.util.ArrayList<>();
		/**
		 * Defines a connection factory.
		 */
		private List<LegacyConnectionFactory> legacyConnectionFactorys = new java.util.ArrayList<>();
		/**
		 * Makes decisions about which node in a cluster should handle a message with a group id assigned.
		 */
		private List<GroupingHandler> groupingHandlers = new java.util.ArrayList<>();
		/**
		 * Defines a JMS topic.
		 */
		private List<JmsTopic> jmsTopics = new java.util.ArrayList<>();
		/**
		 * A connector can be used by a client to define how it connects to a server.
		 */
		private List<Connector> connectors = new java.util.ArrayList<>();
		/**
		 * A security setting allows sets of permissions to be defined against queues based on their address.
		 */
		private List<SecuritySetting> securitySettings = new java.util.ArrayList<>();
		/**
		 * A runtime-only resource representing a ActiveMQ "address". Zero or more queues can be bound to a single address. When a message is routed, it is routed to the set of queues bound to the message's address.
		 */
		private List<CoreAddress> coreAddress = new java.util.ArrayList<>();
		/**
		 * The function of a bridge is to consume messages from a source queue, and forward them to a target address, typically on a different ActiveMQ server.
		 */
		private List<Bridge> bridges = new java.util.ArrayList<>();
		/**
		 * A Queue.
		 */
		private List<Queue> queues = new java.util.ArrayList<>();

		/**
		 * Get the list of ConnectorService resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectorService> connectorServices() {
			return this.connectorServices;
		}

		/**
		 * Get the list of HttpAcceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpAcceptor> httpAcceptors() {
			return this.httpAcceptors;
		}

		/**
		 * Get the list of ClusterConnection resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ClusterConnection> clusterConnections() {
			return this.clusterConnections;
		}

		/**
		 * Get the list of BroadcastGroup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<BroadcastGroup> broadcastGroups() {
			return this.broadcastGroups;
		}

		/**
		 * Get the list of RuntimeQueue resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RuntimeQueue> runtimeQueues() {
			return this.runtimeQueues;
		}

		/**
		 * Get the list of AddressSetting resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AddressSetting> addressSettings() {
			return this.addressSettings;
		}

		/**
		 * Get the list of JmsQueue resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JmsQueue> jmsQueues() {
			return this.jmsQueues;
		}

		/**
		 * Get the list of PooledConnectionFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<PooledConnectionFactory> pooledConnectionFactorys() {
			return this.pooledConnectionFactorys;
		}

		/**
		 * Get the list of Divert resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Divert> diverts() {
			return this.diverts;
		}

		/**
		 * Get the list of InVmAcceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<InVmAcceptor> inVmAcceptors() {
			return this.inVmAcceptors;
		}

		/**
		 * Get the list of DiscoveryGroup resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DiscoveryGroup> discoveryGroups() {
			return this.discoveryGroups;
		}

		/**
		 * Get the list of HttpConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpConnector> httpConnectors() {
			return this.httpConnectors;
		}

		/**
		 * Get the list of ConnectionFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectionFactory> connectionFactorys() {
			return this.connectionFactorys;
		}

		/**
		 * Get the list of Acceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Acceptor> acceptors() {
			return this.acceptors;
		}

		/**
		 * Get the list of RemoteAcceptor resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteAcceptor> remoteAcceptors() {
			return this.remoteAcceptors;
		}

		/**
		 * Get the list of RemoteConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteConnector> remoteConnectors() {
			return this.remoteConnectors;
		}

		/**
		 * Get the list of InVmConnector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<InVmConnector> inVmConnectors() {
			return this.inVmConnectors;
		}

		/**
		 * Get the list of LegacyConnectionFactory resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LegacyConnectionFactory> legacyConnectionFactorys() {
			return this.legacyConnectionFactorys;
		}

		/**
		 * Get the list of GroupingHandler resources
		 * @return the list of resources
		 */
		@Subresource
		public List<GroupingHandler> groupingHandlers() {
			return this.groupingHandlers;
		}

		/**
		 * Get the list of JmsTopic resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JmsTopic> jmsTopics() {
			return this.jmsTopics;
		}

		/**
		 * Get the list of Connector resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Connector> connectors() {
			return this.connectors;
		}

		/**
		 * Get the list of SecuritySetting resources
		 * @return the list of resources
		 */
		@Subresource
		public List<SecuritySetting> securitySettings() {
			return this.securitySettings;
		}

		/**
		 * Get the list of CoreAddress resources
		 * @return the list of resources
		 */
		@Subresource
		public List<CoreAddress> coreAddress() {
			return this.coreAddress;
		}

		/**
		 * Get the list of Bridge resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Bridge> bridges() {
			return this.bridges;
		}

		/**
		 * Get the list of Queue resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Queue> queues() {
			return this.queues;
		}
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public HaPolicySharedStoreColocated haPolicySharedStoreColocated() {
		return this.haPolicySharedStoreColocated;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T haPolicySharedStoreColocated(HaPolicySharedStoreColocated value) {
		this.haPolicySharedStoreColocated = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public HaPolicyReplicationMaster haPolicyReplicationMaster() {
		return this.haPolicyReplicationMaster;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T haPolicyReplicationMaster(HaPolicyReplicationMaster value) {
		this.haPolicyReplicationMaster = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public HaPolicySharedStoreMaster haPolicySharedStoreMaster() {
		return this.haPolicySharedStoreMaster;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T haPolicySharedStoreMaster(HaPolicySharedStoreMaster value) {
		this.haPolicySharedStoreMaster = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public PathBindingsDirectory pathBindingsDirectory() {
		return this.pathBindingsDirectory;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pathBindingsDirectory(PathBindingsDirectory value) {
		this.pathBindingsDirectory = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public HaPolicyReplicationColocated haPolicyReplicationColocated() {
		return this.haPolicyReplicationColocated;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T haPolicyReplicationColocated(HaPolicyReplicationColocated value) {
		this.haPolicyReplicationColocated = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public PathJournalDirectory pathJournalDirectory() {
		return this.pathJournalDirectory;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pathJournalDirectory(PathJournalDirectory value) {
		this.pathJournalDirectory = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public HaPolicySharedStoreSlave haPolicySharedStoreSlave() {
		return this.haPolicySharedStoreSlave;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T haPolicySharedStoreSlave(HaPolicySharedStoreSlave value) {
		this.haPolicySharedStoreSlave = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public PathPagingDirectory pathPagingDirectory() {
		return this.pathPagingDirectory;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pathPagingDirectory(PathPagingDirectory value) {
		this.pathPagingDirectory = value;
		return (T) this;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@Subresource
	public PathLargeMessagesDirectory pathLargeMessagesDirectory() {
		return this.pathLargeMessagesDirectory;
	}

	/**
	 * A filesystem path pointing to one of the locations where ActiveMQ stores persistent data.
	 */
	@SuppressWarnings("unchecked")
	public T pathLargeMessagesDirectory(PathLargeMessagesDirectory value) {
		this.pathLargeMessagesDirectory = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public HaPolicyLiveOnly haPolicyLiveOnly() {
		return this.haPolicyLiveOnly;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T haPolicyLiveOnly(HaPolicyLiveOnly value) {
		this.haPolicyLiveOnly = value;
		return (T) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public HaPolicyReplicationSlave haPolicyReplicationSlave() {
		return this.haPolicyReplicationSlave;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public T haPolicyReplicationSlave(HaPolicyReplicationSlave value) {
		this.haPolicyReplicationSlave = value;
		return (T) this;
	}
}