package org.wildfly.swarm.config.messaging.subsystem.server.coreAddress;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.subsystem.server.coreAddress.role.Role;
/**
 * A runtime-only resource representing a ActiveMQ "address". Zero or more queues can be bound to a single address. When a message is routed, it is routed to the set of queues bound to the message's address.
 */
@Address("/subsystem=messaging-activemq/server=*/core-address=*")
public class CoreAddress<T extends CoreAddress> {

	private String key;
	private List<String> bindingNames;
	private Long numberOfBytesPerPage;
	private Integer numberOfPages;
	private List<String> queueNames;
	private CoreAddressResources subresources = new CoreAddressResources();

	public CoreAddress(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The names of all bindings (both queues and diverts) bound to this address.
	 */
	@ModelNodeBinding(detypedName = "binding-names")
	public List<String> bindingNames() {
		return this.bindingNames;
	}

	/**
	 * The names of all bindings (both queues and diverts) bound to this address.
	 */
	@SuppressWarnings("unchecked")
	public T bindingNames(List<String> value) {
		this.bindingNames = value;
		return (T) this;
	}

	/**
	 * The number of bytes used by each page for this address.
	 */
	@ModelNodeBinding(detypedName = "number-of-bytes-per-page")
	public Long numberOfBytesPerPage() {
		return this.numberOfBytesPerPage;
	}

	/**
	 * The number of bytes used by each page for this address.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfBytesPerPage(Long value) {
		this.numberOfBytesPerPage = value;
		return (T) this;
	}

	/**
	 * The number of pages used by this address.
	 */
	@ModelNodeBinding(detypedName = "number-of-pages")
	public Integer numberOfPages() {
		return this.numberOfPages;
	}

	/**
	 * The number of pages used by this address.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfPages(Integer value) {
		this.numberOfPages = value;
		return (T) this;
	}

	/**
	 * The names of the queues associated with the address.
	 */
	@ModelNodeBinding(detypedName = "queue-names")
	public List<String> queueNames() {
		return this.queueNames;
	}

	/**
	 * The names of the queues associated with the address.
	 */
	@SuppressWarnings("unchecked")
	public T queueNames(List<String> value) {
		this.queueNames = value;
		return (T) this;
	}

	public CoreAddressResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Role objects to this subresource
	 * @return this
	 * @param value List of Role objects.
	 */
	@SuppressWarnings("unchecked")
	public T roles(List<Role> value) {
		this.subresources.roles.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Role object to the list of subresources
	 * @param value The Role to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T role(Role value) {
		this.subresources.roles.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for CoreAddress
	 */
	public class CoreAddressResources {
		/**
		 * A security role.
		 */
		private List<Role> roles = new java.util.ArrayList<>();

		/**
		 * Get the list of Role resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Role> roles() {
			return this.roles;
		}
	}
}