package org.wildfly.swarm.config.messaging.subsystem.server.haPolicy;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@Address("/subsystem=messaging-activemq/server=*/ha-policy=replication-colocated/configuration=master")
@Implicit
public class ConfigurationMaster<T extends ConfigurationMaster> {

	private String key;
	private Boolean checkForLiveServer;
	private String clusterName;
	private String groupName;

	public ConfigurationMaster() {
		this.key = "master";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether to check the cluster for another server using the same server ID when starting up.
	 */
	@ModelNodeBinding(detypedName = "check-for-live-server")
	public Boolean checkForLiveServer() {
		return this.checkForLiveServer;
	}

	/**
	 * Whether to check the cluster for another server using the same server ID when starting up.
	 */
	@SuppressWarnings("unchecked")
	public T checkForLiveServer(Boolean value) {
		this.checkForLiveServer = value;
		return (T) this;
	}

	/**
	 * Name of the cluster used for replication.
	 */
	@ModelNodeBinding(detypedName = "cluster-name")
	public String clusterName() {
		return this.clusterName;
	}

	/**
	 * Name of the cluster used for replication.
	 */
	@SuppressWarnings("unchecked")
	public T clusterName(String value) {
		this.clusterName = value;
		return (T) this;
	}

	/**
	 * If set, backup servers will only pair with live servers with matching group-name.
	 */
	@ModelNodeBinding(detypedName = "group-name")
	public String groupName() {
		return this.groupName;
	}

	/**
	 * If set, backup servers will only pair with live servers with matching group-name.
	 */
	@SuppressWarnings("unchecked")
	public T groupName(String value) {
		this.groupName = value;
		return (T) this;
	}
}