package org.wildfly.swarm.config.messaging.subsystem.server.jmsTopic;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * Defines a JMS topic.
 */
@Address("/subsystem=messaging-activemq/server=*/jms-topic=*")
public class JmsTopic<T extends JmsTopic> {

	private String key;
	private Integer deliveringCount;
	private Integer durableMessageCount;
	private Integer durableSubscriptionCount;
	private List<String> entries;
	private List<String> legacyEntries;
	private Long messageCount;
	private Long messagesAdded;
	private Integer nonDurableMessageCount;
	private Integer nonDurableSubscriptionCount;
	private Integer subscriptionCount;
	private Boolean temporary;
	private String topicAddress;

	public JmsTopic(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@ModelNodeBinding(detypedName = "delivering-count")
	public Integer deliveringCount() {
		return this.deliveringCount;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@SuppressWarnings("unchecked")
	public T deliveringCount(Integer value) {
		this.deliveringCount = value;
		return (T) this;
	}

	/**
	 * The number of messages for all durable subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "durable-message-count")
	public Integer durableMessageCount() {
		return this.durableMessageCount;
	}

	/**
	 * The number of messages for all durable subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T durableMessageCount(Integer value) {
		this.durableMessageCount = value;
		return (T) this;
	}

	/**
	 * The number of durable subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "durable-subscription-count")
	public Integer durableSubscriptionCount() {
		return this.durableSubscriptionCount;
	}

	/**
	 * The number of durable subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T durableSubscriptionCount(Integer value) {
		this.durableSubscriptionCount = value;
		return (T) this;
	}

	/**
	 * The jndi names the topic will be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the topic will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(List<String> value) {
		this.entries = value;
		return (T) this;
	}

	/**
	 * The legacy jndi names the topic will be bound to.
	 */
	@ModelNodeBinding(detypedName = "legacy-entries")
	public List<String> legacyEntries() {
		return this.legacyEntries;
	}

	/**
	 * The legacy jndi names the topic will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T legacyEntries(List<String> value) {
		this.legacyEntries = value;
		return (T) this;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@ModelNodeBinding(detypedName = "message-count")
	public Long messageCount() {
		return this.messageCount;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@SuppressWarnings("unchecked")
	public T messageCount(Long value) {
		this.messageCount = value;
		return (T) this;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@ModelNodeBinding(detypedName = "messages-added")
	public Long messagesAdded() {
		return this.messagesAdded;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@SuppressWarnings("unchecked")
	public T messagesAdded(Long value) {
		this.messagesAdded = value;
		return (T) this;
	}

	/**
	 * The number of messages for all non-durable subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "non-durable-message-count")
	public Integer nonDurableMessageCount() {
		return this.nonDurableMessageCount;
	}

	/**
	 * The number of messages for all non-durable subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T nonDurableMessageCount(Integer value) {
		this.nonDurableMessageCount = value;
		return (T) this;
	}

	/**
	 * The number of non-durable subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "non-durable-subscription-count")
	public Integer nonDurableSubscriptionCount() {
		return this.nonDurableSubscriptionCount;
	}

	/**
	 * The number of non-durable subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T nonDurableSubscriptionCount(Integer value) {
		this.nonDurableSubscriptionCount = value;
		return (T) this;
	}

	/**
	 * The number of (durable and non-durable) subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "subscription-count")
	public Integer subscriptionCount() {
		return this.subscriptionCount;
	}

	/**
	 * The number of (durable and non-durable) subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T subscriptionCount(Integer value) {
		this.subscriptionCount = value;
		return (T) this;
	}

	/**
	 * Whether the topic is temporary.
	 */
	@ModelNodeBinding(detypedName = "temporary")
	public Boolean temporary() {
		return this.temporary;
	}

	/**
	 * Whether the topic is temporary.
	 */
	@SuppressWarnings("unchecked")
	public T temporary(Boolean value) {
		this.temporary = value;
		return (T) this;
	}

	/**
	 * The address the topic points to.
	 */
	@ModelNodeBinding(detypedName = "topic-address")
	public String topicAddress() {
		return this.topicAddress;
	}

	/**
	 * The address the topic points to.
	 */
	@SuppressWarnings("unchecked")
	public T topicAddress(String value) {
		this.topicAddress = value;
		return (T) this;
	}
}