package org.wildfly.swarm.config.messaging.subsystem.server.securitySetting;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging.subsystem.server.securitySetting.role.Role;
/**
 * A security setting allows sets of permissions to be defined against queues based on their address.
 */
@Address("/subsystem=messaging-activemq/server=*/security-setting=*")
public class SecuritySetting<T extends SecuritySetting> {

	private String key;
	private SecuritySettingResources subresources = new SecuritySettingResources();

	public SecuritySetting(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	public SecuritySettingResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Role objects to this subresource
	 * @return this
	 * @param value List of Role objects.
	 */
	@SuppressWarnings("unchecked")
	public T roles(List<Role> value) {
		this.subresources.roles.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Role object to the list of subresources
	 * @param value The Role to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T role(Role value) {
		this.subresources.roles.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for SecuritySetting
	 */
	public class SecuritySettingResources {
		/**
		 * A security role.
		 */
		private List<Role> roles = new java.util.ArrayList<>();

		/**
		 * Get the list of Role resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Role> roles() {
			return this.roles;
		}
	}
}