package org.wildfly.swarm.config.security.subsystem;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Security Vault for attributes.
 */
@Address("/subsystem=security/vault=classic")
@Implicit
public class VaultClassic<T extends VaultClassic> {

	private String key;
	private String code;
	private Map vaultOptions;

	public VaultClassic() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Fully Qualified Name of the Security Vault Implementation.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Fully Qualified Name of the Security Vault Implementation.
	 */
	@SuppressWarnings("unchecked")
	public T code(String value) {
		this.code = value;
		return (T) this;
	}

	/**
	 * Security Vault options.
	 */
	@ModelNodeBinding(detypedName = "vault-options")
	public Map vaultOptions() {
		return this.vaultOptions;
	}

	/**
	 * Security Vault options.
	 */
	@SuppressWarnings("unchecked")
	public T vaultOptions(Map value) {
		this.vaultOptions = value;
		return (T) this;
	}
}