package org.wildfly.swarm.config.security.subsystem.securityDomain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.subsystem.securityDomain.audit.providerModule.ProviderModule;
/**
 * Auditing configuration. Configures a list of provider modules to be used.
 */
@Address("/subsystem=security/security-domain=*/audit=classic")
@Implicit
public class AuditClassic<T extends AuditClassic> {

	private String key;
	private AuditClassicResources subresources = new AuditClassicResources();

	public AuditClassic() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public AuditClassicResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ProviderModule objects to this subresource
	 * @return this
	 * @param value List of ProviderModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T providerModules(List<ProviderModule> value) {
		this.subresources.providerModules.addAll(value);
		return (T) this;
	}

	/**
	 * Add the ProviderModule object to the list of subresources
	 * @param value The ProviderModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T providerModule(ProviderModule value) {
		this.subresources.providerModules.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for AuditClassic
	 */
	public class AuditClassicResources {
		/**
		 * List of modules that map principal, role, and credential information
		 */
		private List<ProviderModule> providerModules = new java.util.ArrayList<>();

		/**
		 * Get the list of ProviderModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ProviderModule> providerModules() {
			return this.providerModules;
		}
	}
}