package org.wildfly.swarm.config.security.subsystem.securityDomain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.subsystem.securityDomain.authentication.loginModuleStack.LoginModuleStack;
import org.wildfly.swarm.config.security.subsystem.securityDomain.authentication.authModule.AuthModule;
/**
 * JASPI authentication configuration.
 */
@Address("/subsystem=security/security-domain=*/authentication=jaspi")
@Implicit
public class AuthenticationJaspi<T extends AuthenticationJaspi> {

	private String key;
	private AuthenticationJaspiResources subresources = new AuthenticationJaspiResources();

	public AuthenticationJaspi() {
		this.key = "jaspi";
	}

	public String getKey() {
		return this.key;
	}

	public AuthenticationJaspiResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all LoginModuleStack objects to this subresource
	 * @return this
	 * @param value List of LoginModuleStack objects.
	 */
	@SuppressWarnings("unchecked")
	public T loginModuleStacks(List<LoginModuleStack> value) {
		this.subresources.loginModuleStacks.addAll(value);
		return (T) this;
	}

	/**
	 * Add the LoginModuleStack object to the list of subresources
	 * @param value The LoginModuleStack to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loginModuleStack(LoginModuleStack value) {
		this.subresources.loginModuleStacks.add(value);
		return (T) this;
	}

	/**
	 * Add all AuthModule objects to this subresource
	 * @return this
	 * @param value List of AuthModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T authModules(List<AuthModule> value) {
		this.subresources.authModules.addAll(value);
		return (T) this;
	}

	/**
	 * Add the AuthModule object to the list of subresources
	 * @param value The AuthModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authModule(AuthModule value) {
		this.subresources.authModules.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for AuthenticationJaspi
	 */
	public class AuthenticationJaspiResources {
		/**
		 * List of "named" login modules that are used by jaspi authentication modules.
		 */
		private List<LoginModuleStack> loginModuleStacks = new java.util.ArrayList<>();
		/**
		 * List of modules that map principal, role, and credential information
		 */
		private List<AuthModule> authModules = new java.util.ArrayList<>();

		/**
		 * Get the list of LoginModuleStack resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModuleStack> loginModuleStacks() {
			return this.loginModuleStacks;
		}

		/**
		 * Get the list of AuthModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AuthModule> authModules() {
			return this.authModules;
		}
	}
}