package org.wildfly.swarm.config.security.subsystem.securityDomain;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.security.subsystem.securityDomain.mapping.mappingModule.MappingModule;
/**
 * Mapping configuration. Configures a list of mapping modules to be used for principal, role, attribute and credential mapping.
 */
@Address("/subsystem=security/security-domain=*/mapping=classic")
@Implicit
public class MappingClassic<T extends MappingClassic> {

	private String key;
	private MappingClassicResources subresources = new MappingClassicResources();

	public MappingClassic() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public MappingClassicResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all MappingModule objects to this subresource
	 * @return this
	 * @param value List of MappingModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T mappingModules(List<MappingModule> value) {
		this.subresources.mappingModules.addAll(value);
		return (T) this;
	}

	/**
	 * Add the MappingModule object to the list of subresources
	 * @param value The MappingModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mappingModule(MappingModule value) {
		this.subresources.mappingModules.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for MappingClassic
	 */
	public class MappingClassicResources {
		/**
		 * List of modules that map principal, role, and credential information
		 */
		private List<MappingModule> mappingModules = new java.util.ArrayList<>();

		/**
		 * Get the list of MappingModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<MappingModule> mappingModules() {
			return this.mappingModules;
		}
	}
}