package org.wildfly.swarm.config.security.subsystem.securityDomain.identityTrust.trustModule;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * List of authentication modules
 */
@Address("/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*")
public class TrustModule<T extends TrustModule> {

	private String key;
	private String code;
	private String flag;
	private String module;
	private Map moduleOptions;

	public TrustModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public T code(String value) {
		this.code = value;
		return (T) this;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@ModelNodeBinding(detypedName = "flag")
	public String flag() {
		return this.flag;
	}

	/**
	 * The flag controls how the module participates in the overall procedure. Allowed values are requisite, required, sufficient or optional.
	 */
	@SuppressWarnings("unchecked")
	public T flag(String value) {
		this.flag = value;
		return (T) this;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of JBoss Module where the login module is located.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		this.module = value;
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOptions(Map value) {
		this.moduleOptions = value;
		return (T) this;
	}
}