package org.wildfly.swarm.config.security.subsystem.securityDomain.mapping.mappingModule;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * List of modules that map principal, role, and credential information
 */
@Address("/subsystem=security/security-domain=*/mapping=classic/mapping-module=*")
public class MappingModule<T extends MappingModule> {

	private String key;
	private String code;
	private String module;
	private Map moduleOptions;
	private String type;

	public MappingModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public T code(String value) {
		this.code = value;
		return (T) this;
	}

	/**
	 * Name of JBoss Module where the mapping module code is located.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of JBoss Module where the mapping module code is located.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		this.module = value;
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOptions(Map value) {
		this.moduleOptions = value;
		return (T) this;
	}

	/**
	 * Type of mapping this module performs. Allowed values are principal, role, attribute or credential..
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * Type of mapping this module performs. Allowed values are principal, role, attribute or credential..
	 */
	@SuppressWarnings("unchecked")
	public T type(String value) {
		this.type = value;
		return (T) this;
	}
}