package org.wildfly.swarm.config.transactions.subsystem.logStore.transactions;

import org.wildfly.config.runtime.Implicit;
import org.wildfly.config.runtime.Address;
import org.wildfly.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.config.runtime.Subresource;
import org.wildfly.swarm.config.transactions.subsystem.logStore.transactions.participants.Participants;
/**
 * The persistent information that the transaction manager stores for the purpose of recovering a transaction in the event of failure. The probe operation will add and remove transactions from the model as the corresponding real transactions start and finish the prepare and commit phases. A stuck transaction will remain in the model until either it is completed or explicitly removed by the delete operation.
 */
@Address("/subsystem=transactions/log-store=log-store/transactions=*")
public class Transactions<T extends Transactions> {

	private String key;
	private Long ageInSeconds;
	private String id;
	private String jmxName;
	private String type;
	private TransactionsResources subresources = new TransactionsResources();

	public Transactions(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The time since this transaction was prepared or when the recovery system last tried to recover it.
	 */
	@ModelNodeBinding(detypedName = "age-in-seconds")
	public Long ageInSeconds() {
		return this.ageInSeconds;
	}

	/**
	 * The time since this transaction was prepared or when the recovery system last tried to recover it.
	 */
	@SuppressWarnings("unchecked")
	public T ageInSeconds(Long value) {
		this.ageInSeconds = value;
		return (T) this;
	}

	/**
	 * The id of this transaction.
	 */
	@ModelNodeBinding(detypedName = "id")
	public String id() {
		return this.id;
	}

	/**
	 * The id of this transaction.
	 */
	@SuppressWarnings("unchecked")
	public T id(String value) {
		this.id = value;
		return (T) this;
	}

	/**
	 * The JMX name of this transaction.
	 */
	@ModelNodeBinding(detypedName = "jmx-name")
	public String jmxName() {
		return this.jmxName;
	}

	/**
	 * The JMX name of this transaction.
	 */
	@SuppressWarnings("unchecked")
	public T jmxName(String value) {
		this.jmxName = value;
		return (T) this;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@SuppressWarnings("unchecked")
	public T type(String value) {
		this.type = value;
		return (T) this;
	}

	public TransactionsResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Participants objects to this subresource
	 * @return this
	 * @param value List of Participants objects.
	 */
	@SuppressWarnings("unchecked")
	public T participants(List<Participants> value) {
		this.subresources.participants.addAll(value);
		return (T) this;
	}

	/**
	 * Add the Participants object to the list of subresources
	 * @param value The Participants to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T participants(Participants value) {
		this.subresources.participants.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Transactions
	 */
	public class TransactionsResources {
		/**
		 * The resources that did work in a transaction.
		 */
		private List<Participants> participants = new java.util.ArrayList<>();

		/**
		 * Get the list of Participants resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Participants> participants() {
			return this.participants;
		}
	}
}